% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mae_pick_samples}
\alias{mae_pick_samples}
\title{Modify samples of multi-assay experiment object}
\usage{
mae_pick_samples(MAE, isolate_samples = NULL, discard_samples = NULL)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{isolate_samples}{Isolate specific samples e.g. c('SAM_01', 'SAM_02')}

\item{discard_samples}{Discard specific samples e.g. c('SAM_01', 'SAM_02')}
}
\value{
A multi-assay experiment object
}
\description{
Modify samples of multi-assay experiment object
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
subset <- mae_pick_samples(toy_data,
  isolate_samples = c(
    "subject_9",
    "subject_14"
  )
)

}
