% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_summary_pie_box.R
\name{filter_summary_pie_box}
\alias{filter_summary_pie_box}
\title{Data visualization by pie chart / box plot}
\usage{
filter_summary_pie_box(
  MAE,
  samples_discard = NULL,
  filter_type,
  sample_condition
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{samples_discard}{The list of samples to filter}

\item{filter_type}{Either 'By Microbes' or 'By Metadata'}

\item{sample_condition}{Which condition to check e.g. 'SEX'}
}
\value{
A plotly object
}
\description{
Data visualization by pie chart / box plot
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
result <- filter_summary_pie_box(toy_data,
  samples_discard = c("subject_2", "subject_4"),
  filter_type = "By Microbes",
  sample_condition = "SEX"
)
result

}
