% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div_test.R
\name{alpha_div_test}
\alias{alpha_div_test}
\title{Get alpha diversity}
\usage{
alpha_div_test(sam_table, alpha_stat)
}
\arguments{
\item{sam_table}{A dataframe with 2 cols, richness and condition. Required.}

\item{alpha_stat}{Wilcoxon rank sum test or T-test for the test}
}
\value{
A dataframe
}
\description{
Get alpha diversity
}
\examples{
df_test <- data.frame(
  richness = seq_len(10),
  condition = c(rep(1, 5), rep(0, 5))
)
alpha_div_test(df_test, alpha_stat = "Wilcoxon rank sum test")

}
