% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interact_foreign.R
\name{build_gene_list_for_pathway}
\alias{build_gene_list_for_pathway}
\title{Build a gene list for a given pathway name}
\usage{
build_gene_list_for_pathway(in_string, in_organism)
}
\arguments{
\item{in_string}{Name or description of the pathway}

\item{in_organism}{Name of the taxon to be searched in}
}
\value{
A character vector of gene names
}
\description{
Build a gene list for a given pathway name
}
\examples{
   species <- "hsa"
   gene_lists_meta_df <- data.frame(
     name=c("BER","NHEJ","MMR"),
     explanation=c("base excision repair",
                   "non homologous end joining",
                   "mismatch repair"))
   number_of_pathways <- dim(gene_lists_meta_df)[1]
   gene_lists_list <- list()
   for (i in seq_len(number_of_pathways)) {
     temp_list <- 
       build_gene_list_for_pathway(gene_lists_meta_df$explanation[i],
                                   species)
     gene_lists_list <- c(gene_lists_list,list(temp_list))
   }
   gene_lists_list
   
}
\seealso{
\code{\link[KEGGREST]{keggLink}}

\code{\link[KEGGREST]{keggFind}}

\code{\link{extract_names_from_gene_list}}
}
