% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCD.R
\name{LCD_complex_cutoff}
\alias{LCD_complex_cutoff}
\alias{LCD_complex_cutoff_perPID}
\alias{LCD_extractCohort_callPerPID}
\alias{LCD_complex_cutoff_consensus}
\alias{LCD_complex_cutoff_combined}
\title{LCD with a signature-specific cutoff on exposures}
\usage{
LCD_complex_cutoff(
  in_mutation_catalogue_df,
  in_signatures_df,
  in_cutoff_vector = NULL,
  in_filename = NULL,
  in_method = "abs",
  in_per_sample_cutoff = 0,
  in_rescale = TRUE,
  in_sig_ind_df = NULL,
  in_cat_list = NULL
)

LCD_complex_cutoff_perPID(
  in_mutation_catalogue_df,
  in_signatures_df,
  in_cutoff_vector = NULL,
  in_filename = NULL,
  in_method = "abs",
  in_rescale = TRUE,
  in_sig_ind_df = NULL,
  in_cat_list = NULL,
  minimumNumberOfAlterations = 25
)

LCD_extractCohort_callPerPID(
  in_mutation_catalogue_df,
  in_signatures_df,
  in_cutoff_vector = NULL,
  in_filename = NULL,
  in_method = "abs",
  in_rescale = TRUE,
  in_sig_ind_df = NULL,
  in_cat_list = NULL,
  in_verbose = FALSE,
  minimumNumberOfAlterations = 25,
  cutoff_type = "adaptive"
)

LCD_complex_cutoff_consensus(
  in_mutation_catalogue_df = NULL,
  in_signatures_df = NULL,
  in_cutoff_vector = NULL,
  in_filename = NULL,
  in_method = "abs",
  in_rescale = TRUE,
  in_sig_ind_df = NULL,
  in_cat_list = NULL,
  in_cohort_LCDlist = NULL,
  in_perPID_LCDlist = NULL,
  addSigs_cohort_cutoff = 0.25,
  addSigs_perPID_cutoff = 0.25,
  addSigs_relAbs_cutoff = 0.01,
  keep.unassigned = FALSE,
  keep.all.cohort.sigs = TRUE,
  in_verbose = FALSE,
  minimumNumberOfAlterations = 25
)

LCD_complex_cutoff_combined(
  in_mutation_catalogue_df = NULL,
  in_signatures_df = NULL,
  in_cutoff_vector = NULL,
  in_filename = NULL,
  in_method = "abs",
  in_rescale = TRUE,
  in_sig_ind_df = NULL,
  in_cat_list = NULL,
  addSigs_cohort_cutoff = 0.25,
  addSigs_perPID_cutoff = 0.25,
  addSigs_relAbs_cutoff = 0.01,
  keep.all.cohort.sigs = TRUE,
  in_verbose = FALSE,
  minimumNumberOfAlterations = 25,
  cutoff_type = "adaptive"
)
}
\arguments{
\item{in_mutation_catalogue_df}{A numeric data frame \code{V} with \code{n}
rows and \code{m} columns, \code{n} being the number of features and
\code{m} being the number of samples}

\item{in_signatures_df}{A numeric data frame \code{W} with \code{n} rows and
\code{l} columns, \code{n} being the number of features and \code{l} being
the number of signatures}

\item{in_cutoff_vector}{A numeric vector of values less than 1. Signatures
from within \code{W} with an overall exposure less than the respective value
in \code{in_cutoff_vector} will be discarded.}

\item{in_filename}{A path to generate a histogram of the signature exposures
if non-NULL}

\item{in_method}{Indicate to which data the cutoff shall be applied: absolute
exposures, relative exposures}

\item{in_per_sample_cutoff}{A numeric value less than 1. Signatures from
within \code{W} with an exposure per sample less than \code{in_cutoff} will
be discarded.}

\item{in_rescale}{Boolean, if TRUE (default) the exposures are rescaled such
that colSums over exposures match colSums over mutational catalogue}

\item{in_sig_ind_df}{Data frame of type signature_indices_df, i.e. indicating
name, function and meta-information of the signatures. Default is NULL.}

\item{in_cat_list}{List of categories for aggregation. Have to be among the
column names of \code{in_sig_ind_df}. Default is NULL.}

\item{minimumNumberOfAlterations}{The perPID part of the analysis issues a
warning if one sample has less mutations than this minimum cutoff.}

\item{in_verbose}{Verbose if \code{in_verbose=1}}

\item{cutoff_type}{If chosen to be "adaptive", the default, then 
signature-specific cutoffs are used for the the per-PID analysis in 
\code{\link[YAPSA]{LCD_extractCohort_callPerPID}}, otherwise, no cutoffs 
are used.}

\item{in_cohort_LCDlist}{Optional, if not provided, the cohort-wide exposures
are recalculated by calling \code{\link[YAPSA]{LCD_complex_cutoff}}}

\item{in_perPID_LCDlist}{Optional, if not provided, the per sample exposures
are recalculated by calling \code{\link[YAPSA]{LCD_complex_cutoff_perPID}}}

\item{addSigs_cohort_cutoff}{Numeric value for a cutoff: signatures which are
detected in a fraction of the samples of the cohort greater than this cutoff
are kept for the consensus set of signatures}

\item{addSigs_perPID_cutoff}{Numeric value for a cutoff: signatures which are
detected in one sample with exposure greater than this cutoff are kept for
the consensus set of signatures}

\item{addSigs_relAbs_cutoff}{Numeric value for a cutoff: signatures which are
detected with at least this fraction of all variants cohort wide are kept
for the consensus set of signatures}

\item{keep.unassigned}{Boolean, if TRUE the exposures from the signatures
which don't fulfill the criteria to be kept will be added and stored in the
exposures as "unassigned", otherwise the exposures are rescaled.}

\item{keep.all.cohort.sigs}{If TRUE (default), all signatures extracted cohort
wide are kept, if FALSE, the function reevaluates whether the signatures
extracted cohort wide still fulfill their criteria (i.e. exposures > cutoff)
after perPID extraction.}
}
\value{
A list with entries: \itemize{ \item \code{exposures}: The exposures
 \code{H}, a numeric data frame with \code{l} rows and \code{m} columns,
 \code{l} being the number of signatures and \code{m} being the number of
 samples \item \code{norm_exposures}: The normalized exposures \code{H}, a
 numeric data frame with \code{l} rows and \code{m} columns, \code{l} being
 the number of signatures and \code{m} being the number of samples \item
 \code{signatures}: The reduced signatures that have exposures bigger than
 \code{in_cutoff} \item \code{choice}: Index vector of the reduced signatures
 in the input signatures \item \code{order}: Order vector of the signatures
 by exposure \item \code{residual_catalogue}: Numerical data frame (matrix)
 of the difference between fit (product of signatures and exposures) and
 input mutational catalogue \item \code{rss}: Residual sum of squares (i.e.
 sum of squares of the residual catalogue) \item
 \code{cosDist_fit_orig_per_matrix}: Cosine distance between the fit (product
 of signatures and exposures) and input mutational catalogue computed after
 putting the matrix into vector format (i.e. one scaler product for the whole
 matrix) \item \code{cosDist_fit_orig_per_col}: Cosine distance between the
 fit (product of signatures and exposures) and input mutational catalogue
 computed per column (i.e. per sample, i.e. as many scaler products as there
 are samples in the cohort) \item \code{sum_ind}: Decreasing order of
 mutational loads based on the input mutational catalogue \item
 \code{out_sig_ind_df}: Data frame of the type \code{signature_indices_df}, 
 i.e. indicating name, function and meta-information of the signatures. 
 Default is NULL, non-NULL only if \code{in_sig_ind_df} is non-NULL. \item
 \code{aggregate_exposures_list}: List of exposure data frames aggregated
 over different categories. Default is NULL, non-NULL only if
 \code{in_sig_ind_df} and \code{in_cat_list} are non-NULL and if the
 categories specified in \code{in_cat_list} are among the column names of
 \code{in_sig_ind_df}. }
}
\description{
\code{LCD_cutoff} performs a mutational signatures decomposition by Linear
Combination Decomposition (LCD) of a given mutational catalogue \code{V} with
known signatures \code{W} by solving the minimization problem \eqn{min(||W*H -
V||)} with additional constraints of non-negativity on H where W and V are
known, but excludes signatures with an overall contribution less than a given
signature-specific cutoff (and thereby accounting for a background model) over
the whole cohort.

\code{\link[YAPSA]{LCD_complex_cutoff_perPID}} is a wrapper for
\code{\link[YAPSA]{LCD_complex_cutoff}} and runs individually for every PID.

\code{\link[YAPSA]{LCD_extractCohort_callPerPID}} runs
\code{\link[YAPSA]{LCD_complex_cutoff}} and takes the identified signatures as 
input for \code{\link[YAPSA]{LCD_complex_cutoff_perPID}}.

\code{\link[YAPSA]{LCD_complex_cutoff_consensus}} calls
\code{\link[YAPSA]{LCD_complex_cutoff_combined}} AND
\code{\link[YAPSA]{LCD_complex_cutoff_perPID}} and makes a consensus
signature call set.

\code{\link[YAPSA]{LCD_complex_cutoff_combined}} is a wrapper for
\code{\link[YAPSA]{LCD_complex_cutoff}},
\code{\link[YAPSA]{LCD_complex_cutoff_perPID}},
\code{\link[YAPSA]{LCD_complex_cutoff_consensus}} AND
\code{\link[YAPSA]{LCD_extractCohort_callPerPID}}.
}
\examples{
 NULL

}
\seealso{
\code{\link[YAPSA]{LCD}}

\code{\link[YAPSA]{aggregate_exposures_by_category}}

\code{\link[limSolve]{lsei}}
}
