% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate_Fun.R
\name{aggValue}
\alias{aggValue}
\title{Perform data aggregations based on the available tree structures}
\usage{
aggValue(
  x,
  rowLevel = NULL,
  rowBlock = NULL,
  colLevel = NULL,
  colBlock = NULL,
  FUN = sum,
  assay = NULL,
  message = FALSE
)
}
\arguments{
\item{x}{A \code{TreeSummarizedExperiment} object.}

\item{rowLevel}{A numeric (node numbers) or character (node labels) vector.
It provides the level on the tree that data is aggregated to. The
aggregation is on the row dimension. The default is \code{rowLevel = NULL},
and no aggregation is performed.}

\item{rowBlock}{A column name in the \code{rowData} to separate the
aggregation.}

\item{colLevel}{A numeric (node numbers) or character (node labels) vector.
It provides the level on the tree that data is aggregated to. The
aggregation is on the column dimension. The default is \code{colLevel =
NULL}, and no aggregation is performed.}

\item{colBlock}{A column name in the \code{colData} to separate the
aggregation.}

\item{FUN}{A function to be applied on the aggregation. It's similar to the
\code{FUN} in \code{\link[base]{apply}}.}

\item{assay}{A integer scalar or string indicating which assay of \code{x} to
use in the aggregation. If NULL, all assay tables are used in aggregation.}

\item{message}{A logical value. The default is TRUE. If TRUE, it will print
out the running process.}
}
\value{
A \code{TreeSummarizedExperiment} object or a
  \code{matrix}. The output has the same class of the input \code{x}.
}
\description{
\code{aggValue} aggregates values on the leaf nodes of a tree to a specific
arbitrary level of the tree. The level is specified via the nodes of the
tree. Users could decide on which dimension (row or column) and how should
the aggregation be performed.
}
\seealso{
\code{\link{aggTSE}}
}
\author{
Ruizhu HUANG
}
