% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxH5-class.R
\name{TENxH5}
\alias{TENxH5}
\title{TENxH5: Represent H5 files from 10X}
\usage{
TENxH5(resource, version, group, ranges, rowidx, colidx, ...)
}
\arguments{
\item{resource}{character(1) The path to the file}

\item{version}{character(1) There are currently two recognized versions
associated with 10X data, either version "2" or "3". See details for more
information.}

\item{group}{character(1) The HDF5 group embedded within the file structure,
this is usually either the "matrix" or "outs" group but other groups are
supported as well (e.g., "mm10").}

\item{ranges}{character(1) The HDF5 internal folder location embedded within
the file that points to the ranged data information, e.g.,
"/features/interval". Set to \code{NA_character_} if range information is not
present.}

\item{rowidx, colidx}{numeric() A vector of indices corresponding to either
rows or columns that will dictate the data imported from the file. The
indices will be passed on to the \code{[} method of the \code{TENxMatrix}
representation.}

\item{...}{Additional inputs to the low level class generator functions}
}
\value{
Usually, a \code{SingleCellExperiment} instance
}
\description{
This constructor function was developed using the PBMC 3K dataset from 10X
Genomics (version 3). Other versions are supported and input arguments
\code{version} and \code{group} can be overridden.
}
\details{
The various \code{TENxH5} methods including \code{rowData} and \code{rowRanges},
provide a snapshot of the data using a length 12 head and tail subset for
efficiency. In contrast, methods such as \code{dimnames} and \code{dim} give
a full view of the dimensions of the data. The \code{show} method provides
relevant information regarding the dimensions of the data including
metadata such as \code{rowData} and "Type" column, if available. The data files
are \code{import}ed as \code{SingleCellExperiment} class objects.

An additional \code{ref} argument can be provided when the file contains
multiple \code{feature_type} in the file or "Type" in the \code{rowData}. By default,
the first type reported in \code{table()} is set as the \code{mainExpName} in the
\code{SingleCellExperiment} object.

For data that do not contain genomic coordinate information, the \code{TENxH5}
will fail to read \code{"/features/interval"} and will set the \code{ranges}
argument to \code{NA_character_}.

The data version "3" mainly includes a "matrix" group and "interval"
information within the file. Version "2" data does not include
ranged-based information and has a different directory structure compared
to version "3". See the internal \code{data.frame}: \code{TENxIO:::h5.version.map}
for a map of fields and their corresponding file locations within the H5
file. This map is used to create the \code{rowData} structure from the file.
}
\examples{

h5f <- system.file(
    "extdata", "pbmc_granulocyte_ff_bc_ex.h5",
    package = "TENxIO", mustWork = TRUE
)

TENxH5(h5f)

import(TENxH5(h5f))

h5f <- system.file(
    "extdata", "10k_pbmc_ATACv2_f_bc_ex.h5",
    package = "TENxIO", mustWork = TRUE
)

## Optional ref input, most frequent Type used by default
th5 <- TENxH5(h5f, ranges = "/features/id", ref = "Peaks")
th5
TENxH5(h5f, ranges = "/features/id")
import(th5)

}
\seealso{
\code{import} section in \linkS4class{TENxH5}
}
