% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxFragments-class.R
\docType{class}
\name{TENxFragments-class}
\alias{TENxFragments-class}
\alias{.TENxFragments}
\alias{import,TENxFragments,ANY,ANY-method}
\title{TENxFragments: A class to represent fragments data as \code{GRanges}}
\usage{
\S4method{import}{TENxFragments,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{...}{Parameters to pass to the format-specific method.}
}
\value{
A \code{TENxFragments} class object
}
\description{
This class is designed to work mainly with \code{fragments.tsv.gz} files from
10x pipelines.
}
\details{
Fragments data from 10x can be quite large. In order to speed up
the initial exploration of the data, we use a default of \strong{200} records
for loading. Users can change this default value by specifying a new one
via the \code{yieldSize} argument in the constructor function.
}
\section{Methods (by generic)}{
\itemize{
\item \code{import(con = TENxFragments, format = ANY, text = ANY)}: Import method for representing fragments.tsv.gz
data from 10x via \code{Rsamtools} and \code{RaggedExperiment}

}}
\section{Slots}{

\describe{
\item{\code{which}}{GRanges() A GRanges indicating the regions of interest. This
get sent to \code{RSamtools} as the \code{param} input.}

\item{\code{yieldSize}}{numeric() The number of records to read by default, 200
records will be imported. A warning will be emitted if not modified.}
}}

