% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curatedTCGAData-helpers.R
\name{curatedTCGAData-helpers}
\alias{curatedTCGAData-helpers}
\alias{getSubtypeMap}
\alias{getClinicalNames}
\alias{TCGAsplitAssays}
\alias{sampleTables}
\title{Helper functions for managing MultiAssayExperiment from
curatedTCGAData}
\usage{
getSubtypeMap(multiassayexperiment)

getClinicalNames(diseaseCode)

TCGAsplitAssays(multiassayexperiment, sampleCodes = NULL, exclusive = FALSE)

sampleTables(multiassayexperiment, vial = FALSE)
}
\arguments{
\item{multiassayexperiment}{A
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
object}

\item{diseaseCode}{A TCGA cancer code (e.g., "BRCA")}

\item{sampleCodes}{character (default NULL) A string of sample type codes
(refer to \code{data(sampleTypes)}; \code{TCGAsplitAssays} section)}

\item{exclusive}{logical (default FALSE) Whether to return only assays that
contain all codes in \code{sampleCodes}}

\item{vial}{(logical default FALSE) whether to display vials in the
table output}
}
\value{
\itemize{
\item{getSubtypeMap}: A \code{data.frame} with explanatory names
and their in-data variable names. They may not be present for all
cancer types.
\item{getClinicalNames}: A \code{vector} of common variable names that
may be found across several cancer disease codes.
}
}
\description{
Additional helper functions for cleaning and uncovering metadata
within a downloaded \code{MultiAssayExperiment} from \code{curatedTCGAData}.
}
\details{
Note that for \code{getSubtypeMap}, the column of in-data variable names
may need to go through \code{make.names} to be found in the \code{colData} of the
\code{MultiAssayExperiment}.
}
\section{getSubtypeMap}{
 provides a two column \code{data.frame} with
interpreted names and in-data variable names. 'Name' usually refers to the
\code{colData} row names a.k.a. the \code{patientID}.
}

\section{getClinicalNames}{
 provides a vector of common variable names that
exist in the \code{colData} \code{DataFrame} of a \code{curatedTCGAData}
\code{MultiAssayExperiment} object. These variables are directly obtained
from the BroadFirehose clinical data (downloaded with
\link[RTCGAToolbox]{getFirehoseData}) and tend to be present across cancer
disease codes.
}

\section{TCGAsplitAssays}{

Separates samples by indicated sample codes into different assays
in a \code{MultiAssayExperiment}. Refer to the \code{sampleTypes}
data object for a list of available codes. This operation generates
\strong{n} times the number of assays based on the number of sample codes
entered. By default, all assays will be split by samples present in
the data.
}

\section{sampleTables}{

Display all the available samples in each of the assays
}

\examples{

library(curatedTCGAData)

gbm <- curatedTCGAData("GBM", c("RPPA*", "CNA*"), version = "2.0.1", FALSE)

getSubtypeMap(gbm)

sampleTables(gbm)

TCGAsplitAssays(gbm, c("01", "10"))

getClinicalNames("COAD")

}
