% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{spectra-plotting}
\alias{spectra-plotting}
\alias{plotSpectraMirror}
\alias{plotSpectra}
\alias{plotSpectraOverlay}
\alias{plotSpectraMirror,Spectra-method}
\title{Plotting Spectra}
\usage{
plotSpectra(
  x,
  xlab = "m/z",
  ylab = "intensity",
  type = "h",
  xlim = numeric(),
  ylim = numeric(),
  main = character(),
  col = "#00000080",
  labels = list(),
  labelCex = 1,
  labelSrt = 0,
  labelAdj = NULL,
  labelPos = NULL,
  labelOffset = 0.5,
  labelCol = "#00000080",
  asp = 1,
  ...
)

plotSpectraOverlay(
  x,
  xlab = "m/z",
  ylab = "intensity",
  type = "h",
  xlim = numeric(),
  ylim = numeric(),
  main = paste(length(x), "spectra"),
  col = "#00000080",
  labels = list(),
  labelCex = 1,
  labelSrt = 0,
  labelAdj = NULL,
  labelPos = NULL,
  labelOffset = 0.5,
  labelCol = "#00000080",
  axes = TRUE,
  frame.plot = axes,
  ...
)

\S4method{plotSpectraMirror}{Spectra}(
  x,
  y,
  xlab = "m/z",
  ylab = "intensity",
  type = "h",
  xlim = numeric(),
  ylim = numeric(),
  main = character(),
  col = "#00000080",
  labels = list(),
  labelCex = 1,
  labelSrt = 0,
  labelAdj = NULL,
  labelPos = NULL,
  labelOffset = 0.5,
  labelCol = "#00000080",
  axes = TRUE,
  frame.plot = axes,
  ppm = 20,
  tolerance = 0,
  matchCol = "#80B1D3",
  matchLwd = 1,
  matchLty = 1,
  matchPch = 16,
  ...
)
}
\arguments{
\item{x}{a \code{\link[=Spectra]{Spectra()}} object. For \code{plotSpectraMirror()} it has to be an
object of length 2.}

\item{xlab}{\code{character(1)} with the label for the x-axis (by default
\code{xlab = "m/z"}).}

\item{ylab}{\code{character(1)} with the label for the y-axis (by default
\code{ylab = "intensity"}).}

\item{type}{\code{character(1)} specifying the type of plot. See \code{\link[=plot.default]{plot.default()}}
for details. Defaults to \code{type = "h"} which draws each peak as a line.}

\item{xlim}{\code{numeric(2)} defining the x-axis limits. The range of m/z values
are used by default.}

\item{ylim}{\code{numeric(2)} defining the y-axis limits. The range of intensity
values are used by default.}

\item{main}{\code{character(1)} with the title for the plot. By default the
spectrum's MS level and retention time (in seconds) is used.}

\item{col}{color to be used to draw the peaks. Should be either of length 1,
or equal to the number of spectra (to plot each spectrum in a different
color) or be a \code{list} with colors for each individual peak in each
spectrum.}

\item{labels}{allows to specify a label for each peak. Needs to be a \code{list()}
with length equal to the number of spectra (each element of the list
being a \code{character()} with length equal to the number of peaks for that
spectrum), or, ideally, a \code{function} that uses one of the \code{Spectra}'s
variables (see examples below). \code{plotSpectraMirror()} supports only
\code{labels} of type \emph{function}.}

\item{labelCex}{\code{numeric(1)} giving the amount by which the text should be
magnified relative to the default. See parameter \code{cex} in \code{\link[=par]{par()}}.}

\item{labelSrt}{\code{numeric(1)} defining the rotation of the label. See
parameter \code{srt} in \code{\link[=text]{text()}}.}

\item{labelAdj}{see parameter \code{adj} in \code{\link[=text]{text()}}.}

\item{labelPos}{see parameter \code{pos} in \code{\link[=text]{text()}}.}

\item{labelOffset}{see parameter \code{offset} in \code{\link[=text]{text()}}.}

\item{labelCol}{color for the label(s).}

\item{asp}{for \code{plotSpectra()}: the target ratio (columns / rows) when
plotting mutliple spectra (e.g. for 20 spectra use \code{asp = 4/5} for 4
columns and 5 rows or \code{asp = 5/4} for 5 columns and 4 rows; see
\code{\link[grDevices:n2mfrow]{grDevices::n2mfrow()}} for details).}

\item{...}{additional parameters to be passed to the \code{\link[=plot.default]{plot.default()}}
function.}

\item{axes}{\code{logical(1)} whether (x and y) axes should be drawn.}

\item{frame.plot}{\code{logical(1)} whether a box should be drawn around the
plotting area.}

\item{y}{for \code{plotSpectraMirror()}: \code{Spectra} object of length 1 against
which \code{x} should be plotted against.}

\item{ppm}{for \code{plotSpectraMirror()}: m/z relative acceptable difference (in
ppm) for peaks to be considered matching (see \code{\link[MsCoreUtils:matching]{MsCoreUtils::common()}}
for more details).}

\item{tolerance}{for \code{plotSpectraMirror()}: absolute acceptable difference of
m/z values for peaks to be considered matching (see
\code{\link[MsCoreUtils:matching]{MsCoreUtils::common()}} for more details).}

\item{matchCol}{for \code{plotSpectraMirror()}: color for matching peaks.}

\item{matchLwd}{for \code{plotSpectraMirror()}: line width (\code{lwd}) to draw
matching peaks. See \code{\link[=par]{par()}} for more details.}

\item{matchLty}{for \code{plotSpectraMirror()}: line type (\code{lty}) to draw matching
peaks. See \code{\link[=par]{par()}} for more details.}

\item{matchPch}{for \code{plotSpectraMirror()}: point character (\code{pch}) to label
matching peaks. Defaults to \code{matchPch = 16}, set to \code{matchPch = NA} to
disable. See \code{\link[=par]{par()}} for more details.}
}
\value{
These functions create a plot.
}
\description{
\code{\link[=Spectra]{Spectra()}} can be plotted with one of the following functions
\itemize{
\item \code{plotSpectra()}: plots each spectrum in its separate plot by splitting
the plot area into as many panels as there are spectra.
\item \code{plotSpectraOverlay()}: plots all spectra in \code{x} \strong{into the same} plot (as
an overlay).
\item \code{plotSpectraMirror()}: plots a pair of spectra as a \emph{mirror plot}.
Parameters \code{x} and \code{y} both have to be a \code{Spectra} of length 1. Matching
peaks (considering \code{ppm} and \code{tolerance}) are highlighted. See
\code{\link[MsCoreUtils:matching]{MsCoreUtils::common()}} for details on peak matching. Parameters
\code{matchCol}, \code{matchLty}, \code{matchLwd} and \code{matchPch} allow to customize
how matching peaks are indicated.
}
}
\examples{

ints <- list(c(4.3412, 12, 8, 34, 23.4),
    c(8, 25, 16, 32))
mzs <- list(c(13.453421, 43.433122, 46.6653553, 129.111212, 322.24432),
    c(13.452, 43.5122, 129.112, 322.245))

df <- DataFrame(msLevel = c(1L, 1L), rtime = c(123.12, 124))
df$mz <- mzs
df$intensity <- ints
sp <- Spectra(df)

#### --------------------------------------------- ####
##                   plotSpectra                     ##

## Plot one spectrum.
plotSpectra(sp[1])

## Plot both spectra.
plotSpectra(sp)

## Define a color for each peak in each spectrum.
plotSpectra(sp, col = list(c(1, 2, 3, 4, 5), 1:4))

## Color peaks from each spectrum in different colors.
plotSpectra(sp, col = c("green", "blue"))

## Label each peak with its m/z.
plotSpectra(sp, labels = function(z) lapply(mz(z), format, digits = 4))

## Rotate the labels.
plotSpectra(sp, labels = function(z) lapply(mz(z), format, digits = 4),
    labelPos = 2, labelOffset = 0.1, labelSrt = -30)

## Add a custom annotation for each peak.
sp$label <- list(c("", "A", "B", "C", "D"),
    c("Frodo", "Bilbo", "Peregrin", "Samwise"))
    
## Plot each peak in a different color
plotSpectra(sp, labels = sp$label,
    col = list(1:5, 1:4))

## Plot a single spectrum specifying the label.
plotSpectra(sp[2], labels = list(c("A", "B", "C", "D")))


#### --------------------------------------------- ####
##                plotSpectraOverlay                 ##

## Plot both spectra overlaying.
plotSpectraOverlay(sp)

## Use a different color for each spectrum.
plotSpectraOverlay(sp, col = c("#ff000080", "#0000ff80"))

## Label also the peaks with their m/z if their intensity is above 15.
plotSpectraOverlay(sp, col = c("#ff000080", "#0000ff80"),
labels = function(z) {
    lapply(seq_along(mz(z)), function(i) {
            lbls <- format(mz(z)[[i]], digits = 4)
            lbls[intensity(z)[[i]] <= 15] <- ""
            lbls
     })
 })
 abline(h = 15, lty = 2)

## Use different asp values
plotSpectra(sp, asp = 1/2)
plotSpectra(sp, asp = 2/1)

#### --------------------------------------------- ####
##                plotSpectraMirror                  ##

## Plot two spectra against each other.
plotSpectraMirror(sp[1], sp[2])

## Label the peaks with their m/z
plotSpectraMirror(sp[1], sp[2],
    labels = function(z) list(format(mz(z)[[1L]], digits = 3)),
    labelSrt = -30, labelPos = 2, labelOffset = 0.2)
grid()

## The same plot with a tolerance of 0.1 and using a different color to
## highlight matching peaks
plotSpectraMirror(sp[1], sp[2],
    labels = function(z) list(format(mz(z)[[1L]], digits = 3)),
    labelSrt = -30, labelPos = 2, labelOffset = 0.2, tolerance = 0.1,
    matchCol = "#ff000080", matchLwd = 2)
grid()
}
\author{
Johannes Rainer, Sebastian Gibb, Laurent Gatto, Guillaume Deflandre
}
