% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeSampleIDs.R
\name{changeSampleIDs}
\alias{changeSampleIDs}
\title{Change sample IDs}
\usage{
changeSampleIDs(sfe, replacement)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{replacement}{A named character vector whose names are the existing
sample IDs to be changed and whose values are the corresponding
replacements.}
}
\value{
An SFE object.
}
\description{
Change sample IDs in all fields of the SFE object where sample IDs are
present, not just the colData.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData(dataset = "small")
sfe <- changeSampleIDs(sfe, c(Vis5A = "sample01"))
sampleIDs(sfe)
}
\concept{Utilities}
