% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{annotOp}
\alias{annotOp}
\title{Binary operations for geometry of each cell/spot and annotation}
\usage{
annotOp(
  sfe,
  colGeometryName = 1L,
  annotGeometryName = 1L,
  sample_id = "all",
  op = st_intersection
)
}
\arguments{
\item{sfe}{An SFE object.}

\item{colGeometryName}{Name of column geometry for the predicate.}

\item{annotGeometryName}{Name of annotation geometry for the predicate.}

\item{sample_id}{Which sample(s) to operate on. Can be "all" to indicate all
samples.}

\item{op}{A binary operation function for the geometries. Defaults to
\code{\link[sf]{st_intersection}}.}
}
\value{
A \code{sf} data frame with \code{geometry} column containing the
geometries and corresponding column names of sfe as row names. There is no
guarantee that the returned geometries are valid or preserve the geometry
class (e.g. when the intersection of polygons result into a line of a point).
}
\description{
Just like \code{\link{annotPred}}, but performs the operation rather than
predicate. For example, this function would return the geometry of the
intersections between each Visium spot and the tissue boundary for each
sample, rather than whether each Visium spot intersects the tissue boundary.
In case one cell/spot gets broken up into multiple geometries, the union of
those geometries will be taken, so each cell/spot will only get one geometry.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
# Get the intersection of myofibers with each Visium spot
myofibers_on_spots <- annotOp(sfe, "spotPoly",
    annotGeometryName = "myofiber_simplified"
)
}
\seealso{
annotPred
}
\concept{Geometric operations}
