% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_operation.R
\name{SFE-transform}
\alias{SFE-transform}
\alias{transpose}
\alias{mirror}
\alias{rotate}
\alias{translate}
\alias{scale}
\alias{affine}
\title{Affine transfortaion of SFE object in histological space}
\usage{
transpose(sfe, sample_id = "all", maxcell = NULL, filename = "")

mirror(
  sfe,
  sample_id = "all",
  direction = c("vertical", "horizontal"),
  maxcell = NULL,
  filename = ""
)

rotate(sfe, sample_id = "all", degrees, maxcell = 1e+07)

translate(sfe, sample_id = "all", v)

scale(sfe, sample_id = "all", factor)

affine(sfe, sample_id = "all", M, v, maxcell = 1e+07)
}
\arguments{
\item{sfe}{An SFE object.}

\item{sample_id}{Sample(s) to transform.}

\item{maxcell}{Rotating \code{SpatRasterImage} will convert it into
\code{ExtImage}, loading the image into memory. This argument specifies the
maximum number of pixels in the image loaded into memory. The image will be
down sampled to approximately this number of pixels.}

\item{filename}{character. Output filename}

\item{direction}{character. Should (partially) match "vertical" to flip by rows, or "horizontal" to flip by columns}

\item{degrees}{How many degrees to rotate. Positive number means clockwise
and negative number means counterclockwise.}

\item{v}{Vector to spatially translate the SFE object.}

\item{factor}{Numeric, scaling factor.}

\item{M}{A 2x2 numeric matrix for the linear transformation in the xy plane.}
}
\value{
An SFE object with the sample(s) transformed.
}
\description{
These functions perform affine transformations on SFE objects, including all
geometries and images. The transformation is performed on each sample as a
whole. This differs from functions such as \code{\link{mirrorImg}} in that
\code{mirrorImg} and \code{rotateImg} transform the image with the center at
the center of the image itself. In contrast, the center of transformation
here is the center of the bounding box of the entire sample, including
images.
}
\details{
For images that are not loaded into memory, \code{rotateImg} will load
\code{SpatRasterImage} into memory and all image operations except translate
will load \code{BioFormatsImage} into memory.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
sfe2 <- transpose(sfe)
sfe3 <- mirror(sfe)

}
\concept{Geometric operations}
