% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{readAndAddPolygonsToSPE}
\alias{readAndAddPolygonsToSPE}
\title{readAndAddPolygonsToSPE}
\usage{
readAndAddPolygonsToSPE(
  spe,
  polygonsCol = "polygons",
  keepMultiPol = TRUE,
  boundariesType = c("csv", "HDF5", "parquet")
)
}
\arguments{
\item{spe}{A \code{SpatialExperiment} object. The object should contain
metadata with the field \code{"technology"}, specifying the technology used
(e.g., "Nanostring_CosMx", "Vizgen_MERFISH", or "10X_Xenium").}

\item{polygonsCol}{character indicating the name of the polygons column to
add into the colData (default is `polygons`).}

\item{keepMultiPol}{Logical. If \code{TRUE}, multi-polygon features will be
kept when reading the boundary data. Defaults to \code{TRUE}.}

\item{boundariesType}{Character. Specifies the type of boundary file format
to read. Options are \code{"HDF5"} or \code{"parquet"}. Defaults to
\code{"HDF5"}.}
}
\value{
A \code{SpatialExperiment} object with the added polygon data.
}
\description{
Read and Add Polygons to a SpatialExperiment Object

This function reads polygon boundary data based on the technology associated
with the provided SpatialExperiment (SPE) object and adds the polygons to the
SPE.
}
\examples{
example(readCosmxSPE)
spe <- readAndAddPolygonsToSPE(spe)
colData(spe)
}
