% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-runcorr.R
\name{runCORR}
\alias{runCORR}
\alias{runCORR,SingleCellExperiment-method}
\alias{runCORR,SingleCellExperiment}
\alias{runCORR,SVPExperiment-method}
\alias{runCORR,SVPExperiment}
\title{runCORR}
\usage{
runCORR(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  method = c("spearman", "pearson", "bicorr"),
  alternative = c("greater", "two.sided", "less"),
  add.pvalue = FALSE,
  action = c("get", "only"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)

\S4method{runCORR}{SingleCellExperiment}(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  method = c("spearman", "pearson", "bicorr"),
  alternative = c("greater", "two.sided", "less"),
  add.pvalue = FALSE,
  action = c("get", "only"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)

\S4method{runCORR}{SVPExperiment}(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  method = c("spearman", "pearson", "bicorr"),
  alternative = c("greater", "two.sided", "less"),
  add.pvalue = FALSE,
  action = c("get", "only"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{features1}{the features name data object (only supporting character), default is NULL,
see also \code{features2} parameter.}

\item{features2}{character, if \code{features1} is not NULL, and \code{features2} is NULL,
only the \code{features1} are analyzed, if \code{features1} is NULL, and \code{features2} is
is not NULL, the \code{features2} are analyzed, if \code{features2} is also NULL, all of features in the
\code{data} object will be analyzed. If \code{features2} and \code{features1} are not NULL, the bivariate
spatial autocorrelation analysis will be performed between the \code{features1} and \code{features2}.
default is \code{NULL}.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{method}{character should be one of the \code{spearman}, \code{pearson} and \code{bicorr}, default is \code{'spearman'}.}

\item{alternative}{indicates the alternative hypothesis and must be one of \code{"two.sided"}, \code{"greater"} or
\code{"less"}. You can specify just the initial letter. \code{"greater"} corresponds to positive association,
\code{"less"} to negative association, default is \code{"two.sided"}.}

\item{add.pvalue}{logical whether calculate the pvalue, which is calculated with permutation test. So it might
be slow, default is \code{FALSE}, which the pvalue of result will be NULL.}

\item{action}{character, which should be one of \code{'only'} and \code{'get'}, default is \code{"get"}.
If \code{action='only'}, it will return a long tidy table contains the correlation for each feature pairs.
If \code{action='get'}, it will return a list containing the correlation matrix and pvalue matrix (if \code{add.pvalue=TRUE}).}

\item{verbose}{logical whether print the help information, default is TRUE.}

\item{gsvaexp}{character the one character from the name of \code{gsvaExpNames(data)}, default is NULL. If \code{data}
is \linkS4class{SVPExperiment}, and the parameter is specified simultaneously. the \code{features} (Usually genes)
from the displayed class, and \code{gsvaexp.features} from name in \code{rownames(gsvaExp(data, gsvaexp))} will be
performed the analysis.}

\item{gsvaexp.assay.type}{character the assay name in the \code{assays(gsvaExp(data, gsvaexp))}, default is NULL,
which works with \code{gsvaexp} parameter.}

\item{gsvaexp.features}{character the name from the \code{rownames(gsvaExp(data, gsvaexp))}. If \code{gsvaexp} is
specified and \code{data} is \linkS4class{SVPExperiment}, it should be provided. Default is NULL.}

\item{across.gsvaexp}{logical whether only calculate the relationship of features between the multiple \code{gsvaExps}
not the internal features of gsvaExp. For example, \code{'a'} and \code{'b'} features are from the \code{'AB'} \code{gsvaExp},
\code{'c'} and \code{'d'} features are from the \code{'CD'} \code{gsvaExp}. When \code{across.gsvaexp=TRUE} and
\code{gsvaexp.features = c('a', 'b', 'c', 'd')} and \code{gsvaexp = c('AB', 'CD')}, Only the relationship of
\code{a} and \code{c}, \code{a} and \code{d}, \code{b} and \code{c}, and \code{b} and \code{d} will be calculated.
default is TRUE.}

\item{...}{additional parameters the parameters which are from the weight.method function.}
}
\value{
long tidy table or list see also the help information of \code{action} argument.
}
\description{
This function to perform the correlation of the features in main experiment or
features of gsva experiment.
}
\examples{
data(hpda_spe_cell_dec)
rownames(hpda_spe_cell_dec) |> head()
res1 <- runCORR(hpda_spe_cell_dec, 
                features1 = "Ductal APOL1 high-hypoxic", 
                features2 = c('Cancer clone A', "Cancer clone B"), 
                assay.type = 'affi.score', 
                action='only'
        )
res1
res2 <- runCORR(hpda_spe_cell_dec, 
                features1 = c("Acinar cells", 
                              "Ductal APOL1 high-hypoxic", 
                              "Cancer clone A",
                              "Cancer clone B"), 
                assay.type = 1, 
                action = 'get'
        )
res2
}
\seealso{
\code{\link{runCORR}} to explore the global bivariate relationship in the spatial space.
}
\author{
Shuangbin Xu
}
