% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_composition_heatmap.R
\name{plot_composition_heatmap}
\alias{plot_composition_heatmap}
\title{plot_composition_heatmap}
\usage{
plot_composition_heatmap(
  composition,
  pheno_to_exclude = NULL,
  log_values = FALSE,
  feature_colname
)
}
\arguments{
\item{composition}{Data.frame. Output from
\code{\link{composition_of_neighborhoods}}.}

\item{pheno_to_exclude}{String Vector of phenotype to exclude.}

\item{log_values}{Boolean. TRUE if the percentages should be logged (base
10).}

\item{feature_colname}{String. Column with cell types.}
}
\value{
A plot is returned
}
\description{
Produces a heatmap showing the marker percentages within each
  cluster and the cluster sizes.
}
\examples{
neighborhoods <- identify_neighborhoods(image_no_markers, method = "hierarchical",
min_neighborhood_size = 100, cell_types_of_interest = c("Immune", "Immune1", "Immune2"),
radius = 50, feature_colname = "Cell.Type")
neighborhoods_vis <- composition_of_neighborhoods(neighborhoods, feature_colname="Cell.Type")
plot_composition_heatmap(neighborhoods_vis, feature_colname="Cell.Type")
}
