% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_percentage_of_grids.R
\name{calculate_percentage_of_grids}
\alias{calculate_percentage_of_grids}
\title{calculate_percentage_of_grids}
\usage{
calculate_percentage_of_grids(raster_obj, threshold, above)
}
\arguments{
\item{raster_obj}{Raster object in the form of the output of
\code{\link{grid_metrics}}.}

\item{threshold}{Numeric. The threshold for defining the pattern.}

\item{above}{Boolean. Indicating whether the pattern is above (TRUE) or below
(FALSE) the threshold.}
}
\value{
A number is returned
}
\description{
Takes the result of \code{\link{grid_metrics}} (a RasterLayer
  object) and calculates the percentage of the grid squares whose values are
  above or below a specified threshold.
}
\examples{
grid <- grid_metrics(SPIAT::defined_image, FUN = calculate_entropy, n_split = 5,
cell_types_of_interest=c("Tumour","Immune3"), feature_colname = "Cell.Type")
calculate_percentage_of_grids(grid, threshold = 0.75, above = TRUE)
}
