% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsva_plotting_functions.R
\name{plot_gsva_pca,ReactomeAnalysisResult-method}
\alias{plot_gsva_pca,ReactomeAnalysisResult-method}
\title{plot_gsva_pca - ReactomeAnalysisResult}
\usage{
\S4method{plot_gsva_pca}{ReactomeAnalysisResult}(object, pathway_ids = NULL, ...)
}
\arguments{
\item{object}{A \code{\link{ReactomeAnalysisResult}} object containing a ssGSEA result}

\item{pathway_ids}{A character vector of pathway ids. If set, only these pathways will be
used for the PCA analysis.}

\item{...}{Additional parameters are passed to \code{prcomp}}
}
\value{
A ggplot2 object representing the plot.
}
\description{
Runs a Principal Component analysis (using \code{prcomp}) on the samples
based on the pathway analysis results.
}
\examples{
# load the scRNA-seq example data
library(ReactomeGSA.data)
data(jerby_b_cells)

# perform the GSVA analysis
gsva_result <- analyse_sc_clusters(jerby_b_cells, verbose = FALSE)
}
