% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_data.R
\name{find_public_datasets}
\alias{find_public_datasets}
\title{find_public_datasets}
\usage{
find_public_datasets(
  search_term,
  species = "Homo sapiens",
  reactome_url = NULL
)
}
\arguments{
\item{search_term}{The search terms as a single string. Multiple words
(seperated by a space) are combined by an "AND".}

\item{species}{Limit the search to selected species. The complete list of available species can be
retrieved through \code{\link{get_public_species}}. By default, entries as limited to
human datasets.}

\item{reactome_url}{URL of the Reactome API Server. Overwrites the URL set in the 'reactome_gsa.url' option.
Specific ports can be set using the standard URL specification (for example http://your.service:1234)}
}
\value{
A data.frame containing a list of datasets found through the search.
}
\description{
Search for a public dataset in the resources supported
by ReactomeGSA as external data sources.
}
\examples{
# search for any public dataset relating to BRAF in melanoma
melanoma_datasets <- find_public_datasets("melanoma braf")

# it is also possible to limit this to another species than human
melanoma_mouse <- find_public_datasets("melanoma", species = "Mus musculus")

# the list of available species can be retrieved using get_public_species
all_species <- get_public_species()

# datasets can then be loaded using the load_public_dataset function
}
