% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{updateGroupAnnotation}
\alias{updateGroupAnnotation}
\title{Update Group Annotation}
\usage{
updateGroupAnnotation(
  name = NULL,
  annotationName = NULL,
  x.pos = NULL,
  y.pos = NULL,
  angle = NULL,
  canvas = NULL,
  z.order = NULL,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{name}{(optional) Name of annotation object}

\item{annotationName}{Name of annotation by UUID or Name}

\item{x.pos}{(optional) X position in pixels from left; default is center 
of current view}

\item{y.pos}{(optional) Y position in pixels from top; default is center 
of current view}

\item{angle}{(optional) Angle of text orientation; default is 0.0 
(horizontal)}

\item{canvas}{(optional) Canvas to display annotation, i.e., foreground 
(default) or background}

\item{z.order}{(optional) Arrangement order specified by number (larger
values are in front of smaller values); default is 0}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by
this version of RCy3.}
}
\value{
A named list of annotation properties, including UUID
}
\description{
Updates a group annotation, changing the given properties.
}
\examples{
\donttest{
updateGroupAnnotation("test1", "annotationName")
}
}
