% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-NodesAndEdges.R
\name{updateEdges}
\alias{updateEdges}
\alias{updateEdges.EdgesAspect}
\alias{updateEdges.RCX}
\title{Update edges}
\usage{
updateEdges(x, edges, stopOnDuplicates = FALSE, keepOldIds = TRUE, ...)

\method{updateEdges}{EdgesAspect}(x, edges, stopOnDuplicates = FALSE, keepOldIds = TRUE, ...)

\method{updateEdges}{RCX}(
  x,
  edges,
  stopOnDuplicates = FALSE,
  keepOldIds = TRUE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{\link{RCX-object}} or \code{\link{Edges}} object; (to which the new \code{\link{Edges}} will be added)}

\item{edges}{\code{\link{Edges}} object; (the \code{\link{Edges}}, that will be added)}

\item{stopOnDuplicates}{logical (optional); whether to stop, if duplicates in \emph{id} column are found, or re-assign ids instead.}

\item{keepOldIds}{logical (optional); if ids are re-assigned, the original ids are kept in the column \emph{oldId}}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{Edges}} or \link[=RCX-object]{RCX} with added edges
}
\description{
This functions add edges in the form of a \code{\link{Edges}} object to an other \code{\link{Edges}} or an \emph{RCX} object.
}
\details{
When edges should be added to a \code{\link{Edges}} or a \code{\link{RCX-object}} object some conflicts may rise, since the aspects might use
the same IDs. If the aspects do not share any IDs, the two aspects are simply combined. Otherwise, the IDs of the new edges are re-assinged
continuing with the next available ID (i.e. \code{\link{maxId}}(edgesAspect) + 1 and \code{\link{maxId}}(rcx$edges) + 1, respectively).

To keep track of the changes, it is possible to keep the old IDs of the newly added edges in the automatically added column \emph{oldId}.
This can be omitted by setting \emph{keepOldIds} to \code{FALSE}.
Otherwise, if a re-assignment of the IDs is not desired, this can be prevented by setting \emph{stopOnDuplicates} to \code{TRUE}.
This forces the function to stop and raise an error, if duplicated IDs are present.
}
\examples{
## create some edges
edges1 = createEdges(source=c(1,1,0), target=c(2,0,1))
edges2 = createEdges(id=c(3,2,4),
                     source=c(0,0,1), 
                     target=c(1,2,2),
                     interaction=c("activates","inhibits", NA))

## simply add the edges and keep old ids
edges3 = updateEdges(edges1, edges2)

## add the edges
edges4 = updateEdges(edges1, edges2, keepOldIds=FALSE)

## force an error because of duplicated ids
try(updateEdges(edges1, edges2, stopOnDuplicates=TRUE))
## =>Error:
## Elements of "id" (in updateEdges) must not contain duplicates!

## Prepare an RCX object
rcx = createRCX(createNodes(name = c("EGFR","AKT1","WNT")))

## add edges to the RCX object
rcx = updateEdges(rcx, edges1)

## add new edges and don't keep old ids
rcx = updateEdges(rcx, edges2, keepOldIds=FALSE)

## force an error because of duplicated ids
try(updateEdges(rcx, edges2, stopOnDuplicates=TRUE))
## =>Error:
## Elements of "id" (in updateEdges) must not contain duplicates!
}
