% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-checks.R
\name{checks}
\alias{checks}
\alias{.paramClass}
\alias{.checkClass}
\alias{.checkAllClass}
\alias{.checkClassOneOf}
\alias{.checkCharacter}
\alias{.checkNumeric}
\alias{.checkLogical}
\alias{.checkList}
\alias{.paramNamed}
\alias{.checkNamed}
\alias{.checkNamedCharacter}
\alias{.checkNamedNumeric}
\alias{.checkNamedLogical}
\alias{.checkNamedList}
\alias{.paramNonNeg}
\alias{.checkNonNeg}
\alias{.paramNoNa}
\alias{.checkNoNa}
\alias{.checkIsUniqueId}
\alias{.checkIsId}
\alias{.paramIsOptionalId}
\alias{.checkSameLength}
\alias{.paramAnyNotNull}
\alias{.checkAnyNotNull}
\alias{.elementsUnique}
\alias{.checkUnique}
\alias{.elementsUniqueDF}
\alias{.checkUniqueDF}
\alias{.elementsInDict}
\alias{.elementsBContainsAllA}
\alias{.checkBContainsAllA}
\alias{.checkRefs}
\alias{.checkRefPresent}
\alias{.listAllNumeric}
\alias{.checkAllNumeric}
\alias{.listAllNumericOrInDict}
\alias{.checkAllNumericOrInDict}
\title{Checks}
\usage{
.paramClass(param, cls)

.checkClass(param, cls, name, cname = c())

.checkAllClass(L, cls, name, cname = c())

.checkClassOneOf(param, clss, name, cname = c())

.checkCharacter(param, name, cname = c())

.checkNumeric(param, name, cname = c())

.checkLogical(param, name, cname = c())

.checkList(param, name, cname = c())

.paramNamed(param)

.checkNamed(param, name, cname = c())

.checkNamedCharacter(param, name, cname = c())

.checkNamedNumeric(param, name, cname = c())

.checkNamedLogical(param, name, cname = c())

.checkNamedList(param, name, cname = c())

.paramNonNeg(param)

.checkNonNeg(param, name, cname = c())

.paramNoNa(param)

.checkNoNa(param, name, cname = c())

.checkIsUniqueId(param, name, cname = c())

.checkIsId(param, name, cname = c())

.paramIsOptionalId(param, name)

.checkSameLength(cname, ...)

.paramAnyNotNull(name, ...)

.checkAnyNotNull(name, cname = c(), ...)

.elementsUnique(A)

.checkUnique(A, name, cname = c())

.elementsUniqueDF(DF, cols)

.checkUniqueDF(DF, cols, cname = c())

.elementsInDict(A, key)

.elementsBContainsAllA(A, B)

.checkBContainsAllA(A, B, name, cname = c())

.checkRefs(A, B, name, cname = c())

.checkRefPresent(A, key, cls, name, cname = c())

.listAllNumeric(L)

.checkAllNumeric(L, name, cname = c())

.listAllNumericOrInDict(L, key)

.checkAllNumericOrInDict(L, key, name, cname = c())
}
\arguments{
\item{param}{some parameter.}

\item{cls}{character; class name.}

\item{name}{character; for logging the used name for the parameter.}

\item{cname}{character; for logging the name of the calling function.}

\item{L}{list.}

\item{clss}{character vector; list of class names.}

\item{...}{list of some vectors.}

\item{A, B}{vectors.}

\item{DF}{data.frame.}

\item{cols}{column names.}

\item{key}{name of the dictionary entry in \code{.DICT}.}
}
\value{
logical
}
\description{
Different functions to check parameters, ids, elements and lists
}
\details{
The \verb{.check*} functions perform a test and stop with a custom error on fail.
All other functions perform a test and return the result.

The used \strong{.DICT:} looks as follows:

\itemize{
\item VPpropertiesOf: network, nodes, edges, nodes:default, edges:default
\item VPpropertyFields: properties, dependencies, mappings
\item SN: all
\item TCappliesTo: nodes, edges, networks
}
}
\section{Functions}{
\itemize{
\item \code{.paramClass()}: checks if the object \code{param} is of class \code{cls}.

\item \code{.checkClass()}: checks if the object \code{param} is of class \code{cls}.

\item \code{.checkAllClass()}: checks if all elements of the list \code{L} are of class \code{cls}.

\item \code{.checkClassOneOf()}: checks if \code{param} is any class of \code{clss}.

\item \code{.checkCharacter()}: checks if \code{param} is character.

\item \code{.checkNumeric()}: checks if \code{param} is numeric.

\item \code{.checkLogical()}: checks if \code{param} is logical.

\item \code{.checkList()}: checks if \code{param} is a list.

\item \code{.paramNamed()}: checks if \code{param} has names.

\item \code{.checkNamed()}: checks if \code{param} has names.

\item \code{.checkNamedCharacter()}: checks if \code{param} has names and is character.

\item \code{.checkNamedNumeric()}: checks if \code{param} has names and is numeric.

\item \code{.checkNamedLogical()}: checks if \code{param} has names and is logical.

\item \code{.checkNamedList()}: checks if \code{param} has names and is a list.

\item \code{.paramNonNeg()}: checks if \code{param} is greater than 0 if not NA.

\item \code{.checkNonNeg()}: checks if \code{param} is greater than 0 if not NA.

\item \code{.paramNoNa()}: checks if \code{param} is not NA.

\item \code{.checkNoNa()}: checks if \code{param} is not NA.

\item \code{.checkIsUniqueId()}: checks if \code{param} is an unique id.

\item \code{.checkIsId()}: checks if \code{param} is an id.

\item \code{.paramIsOptionalId()}: checks if \code{param} is an optional id.

\item \code{.checkSameLength()}: checks if all elements in \code{...} have the same number of elements.

\item \code{.paramAnyNotNull()}: checks if any element in \code{...} is not NULL.

\item \code{.checkAnyNotNull()}: checks if any element in \code{...} is not NULL.

\item \code{.elementsUnique()}: checks if the elements in \code{A} are unique.

\item \code{.checkUnique()}: checks if the elements in \code{A} are unique.

\item \code{.elementsUniqueDF()}: checks if the elements in the columns \code{cols} of \code{DF} are unique.

\item \code{.checkUniqueDF()}: checks if the elements in the columns \code{cols} of \code{DF} are unique.

\item \code{.elementsInDict()}: checks if the elements of \code{A} are in \code{.DICT[[key]]}.

\item \code{.elementsBContainsAllA()}: checks if all elements of \code{A} are present in \code{B}.

\item \code{.checkBContainsAllA()}: checks if all elements of \code{A} are present in \code{B}.

\item \code{.checkRefs()}: checks if \code{B} contains all elements of \code{A}, aka. references.

\item \code{.checkRefPresent()}: checks if a referred aspect of class \code{cls} is accessible by \code{key} in \code{A}.

\item \code{.listAllNumeric()}: checks if all elements of a list \code{L} are numeric.

\item \code{.checkAllNumeric()}: checks if all elements of a list \code{L} are numeric.

\item \code{.listAllNumericOrInDict()}: checks if all elements of a list \code{L} are numeric or in \code{.DICT[[key]]}.

\item \code{.checkAllNumericOrInDict()}: checks if all elements of a list \code{L} are numeric or in \code{.DICT[[key]]}.

}}
\note{
Internal function only for convenience
}
\examples{
NULL
}
\keyword{internal}
