% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_plots.R
\name{te_rna.plot}
\alias{te_rna.plot}
\title{Translational efficiency plots}
\usage{
te_rna.plot(
  dt,
  output.dir = NULL,
  filter.rfp = 1,
  filter.rna = 1,
  plot.title = "",
  plot.ext = ".pdf",
  width = 6,
  height = "auto",
  dpi = 300,
  dot.size = 0.4,
  xlim = c(filter.rna, filter.rna + 2.5)
)
}
\arguments{
\item{dt}{a data.table with the results from \code{\link{te.table}}}

\item{output.dir}{a character path, default NULL(no save), or a directory
to save to a file will be called "TE_within.pdf"}

\item{filter.rfp}{numeric, default 1. What is the minimum fpkm value?}

\item{filter.rna}{numeric, default 1. What is the minimum fpkm value?}

\item{plot.title}{title for plots, usually name of experiment etc}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".
Multiple values allowed, if so will save file in each format specified.}

\item{width}{numeric, default 6 (in inches)}

\item{height}{a numeric, width of plot in inches. Default "auto".}

\item{dpi}{numeric, default 300.}

\item{dot.size}{numeric, default 0.4, size of point dots in plot.}

\item{xlim}{numeric vector of length 2. X-axis limits. Default:
\code{c(filter.rna, filter.rna + 2.5)}}
}
\value{
a ggplot object
}
\description{
Create TE plot of:\cr
- Within sample (TE log2 vs mRNA fpkm)\cr
}
\examples{
df <- ORFik.template.experiment()
df.rfp <- df[df$libtype == "RFP",]
df.rna <- df[df$libtype == "RNA",]
#dt <- te.table(df.rfp, df.rna)
#te_rna.plot(dt, filter.rfp = 0, filter.rna = 5, dot.size = 1)
}
\seealso{
Other DifferentialExpression: 
\code{\link{DEG.plot.static}()},
\code{\link{DEG_model}()},
\code{\link{DTEG.analysis}()},
\code{\link{DTEG.plot}()},
\code{\link{te.table}()}
}
\concept{DifferentialExpression}
