% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_helpers.R
\name{scaledWindowPositions}
\alias{scaledWindowPositions}
\title{Scale (bin) windows to a meta window of given size}
\usage{
scaledWindowPositions(
  grl,
  reads,
  scaleTo = 100,
  scoring = "meanPos",
  weight = "score",
  is.sorted = FALSE,
  drop.zero.dt = FALSE
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} of 5' utrs, CDS, transcripts, etc.}

\item{reads}{a \code{\link{GAlignments}}, \code{\link{GRanges}}, or
precomputed coverage as \code{\link{covRle}} (one for each strand) of
RiboSeq, RnaSeq etc.\cr Weigths for scoring is default the 'score'
column in 'reads'. Can also be random access paths to bigWig or fstwig file.
Do not use random access for more than a few genes, then loading the entire files
is usually better. File streaming is still in beta, so use with care!}

\item{scaleTo}{an integer (100), if windows have different size,
a meta window can not directly be created, since a meta window must
have equal size for all windows. Rescale all windows to scaleTo.
i.e c(1,2,3) -> size 2 -> c(1, mean(2,3)) etc. Can also be a vector,
1 number per grl group.}

\item{scoring}{a character, one of (zscore, transcriptNormalized,
mean, median, sum, log2sum, log10sum, sumLength, meanPos and frameSum,
periodic, NULL). More info in details}

\item{weight}{(default: 'score'), if defined a character name
of valid meta column in subject. GRanges("chr1", 1, "+", score = 5),
would mean score column tells that this alignment region was found 5 times.
Formats which loads a score column like this:
Bigwig, wig, ORFik ofst, collapsed bam, bedoc and .bedo.
As do CAGEr CAGE files and many other package formats.
You can also assign a score column manually.}

\item{is.sorted}{logical (FALSE), is grl sorted. That is + strand groups in
increasing ranges (1,2,3), and - strand groups in decreasing ranges (3,2,1)}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}
}
\value{
A data.table with scored counts (counts) of
reads mapped to positions (position) specified in windows along with
frame (frame).
}
\description{
For example scale a coverage table of a all human CDS to width 100
}
\details{
Nice for making metaplots, the score will be mean of merged positions.
}
\examples{
library(GenomicRanges)
windows <- GRangesList(GRanges("chr1", IRanges(1, 200), "-"))
x <- GenomicRanges::GRanges(
  seqnames = "chr1",
  ranges =  IRanges::IRanges(c(1, 100, 199), c(2, 101, 200)),
  strand = "-")
scaledWindowPositions(windows, x, scaleTo = 100)

}
\seealso{
Other coverage: 
\code{\link{coverageScorings}()},
\code{\link{metaWindow}()},
\code{\link{regionPerReadLength}()},
\code{\link{windowPerReadLength}()}
}
\concept{coverage}
