% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GO_analysis.R
\name{DEG_gorilla_copy_to_local}
\alias{DEG_gorilla_copy_to_local}
\title{Copy GOrilla result htmls to local}
\usage{
DEG_gorilla_copy_to_local(
  gorilla_output_dir,
  local_html_dir = file.path(gorilla_output_dir, "GOrilla_local_html_outputs")
)
}
\arguments{
\item{gorilla_output_dir}{character, directory path to existing results of a
DEG_gorilla call. Must contain a file with relative path "./All_contrasts_GOrilla_urls.csv"}

\item{local_html_dir}{character, output directory,
default: \code{file.path(gorilla_output_dir, "GOrilla_local_html_outputs")}}
}
\value{
invisible(NULL), files are saved to disc.
}
\description{
Will retrieve full html, png and xls structure so analysis can be used even
when results are deleted online (1 month after creation).\cr
Files are saved to disc in directory "./GOrilla_local_html_outputs/", relative
to input directory 'gorilla_output_dir'. There is 1 subfolder per
analysis url. Open the GOResults.html to view.
}
\seealso{
Other GOrilla: 
\code{\link{DEG_gorilla}()}
}
\concept{GOrilla}
