% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{calculate_density}
\alias{calculate_density}
\title{Estimate weighted kernel density}
\usage{
calculate_density(w, x, method, adjust = 1, map = TRUE)
}
\arguments{
\item{w}{Vector with weights for each observation}

\item{x}{Matrix with dimensions where to calculate the density from. Only
the first two dimensions will be used}

\item{method}{Kernel density estimation method:
\itemize{
\item \code{ks}: Computes density using the \code{kde} function from the
 \code{ks} package.
\item \code{wkde}: Computes density using a modified version of the
 \code{kde2d} function from the \code{MASS}
package to allow weights. Bandwidth selection from the \code{ks} package
 is used instead.
}}

\item{adjust}{Numeric value to adjust to bandwidth. Default: 1. Not available
for \code{ks} method}

\item{map}{Whether to map densities to individual observations}
}
\value{
If \code{map} is \code{TRUE}, a vector with corresponding densities
 for each observation is returned. Otherwise,
a list with the density estimates from the selected method is returned.
}
\description{
Estimate weighted kernel density
}
\examples{

dens <- Nebulosa:::calculate_density(iris[, 3], iris[, 1:2], method = "wkde")
}
\author{
Jose Alquicira-Hernandez
}
