% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapply.R
\name{vapply1c}
\alias{vapply1c}
\alias{vapply1d}
\alias{vapply1l}
\title{vapply wrappers}
\usage{
vapply1c(X, FUN, ..., USE.NAMES = FALSE)

vapply1d(X, FUN, ..., USE.NAMES = FALSE)

vapply1l(X, FUN, ..., USE.NAMES = FALSE)
}
\arguments{
\item{X}{a vector (atomic or \code{list}).}

\item{FUN}{the \code{function} to be applied to each element of \code{X}.}

\item{...}{optional arguments to \code{FUN}.}

\item{USE.NAMES}{\code{logical}, should the return value be named.}
}
\value{
\code{vapply1c} returns a vector of \code{character}s of length \code{X}.

\code{vapply1d} returns a vector of \code{double}s of length \code{X}.

\code{vapply1l} returns a vector of \code{logical}s of length \code{X}.
}
\description{
These functions are short wrappers around typical \code{vapply} calls for easier
development.
}
\examples{
l <- list(a=1:3, b=4:6)
vapply1d(l, sum)
}
\seealso{
Other helper functions for developers: 
\code{\link{between}()},
\code{\link{isPeaksMatrix}()},
\code{\link{rbindFill}()},
\code{\link{validPeaksMatrix}()},
\code{\link{which.first}()}
}
\author{
Sebastian Gibb
}
\concept{helper functions for developers}
