% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendMetaboLights.R
\name{MetaboLights-utils}
\alias{MetaboLights-utils}
\alias{mtbls_ftp_path}
\alias{mtbls_list_files}
\alias{mtbls_sync_data_files}
\alias{mtbls_cached_data_files}
\alias{mtbls_delete_cache}
\title{Utility functions for the MetaboLights repository}
\usage{
mtbls_ftp_path(x = character(), mustWork = TRUE)

mtbls_list_files(x = character(), pattern = NULL)

mtbls_sync_data_files(
  mtblsId = character(),
  assayName = character(),
  pattern = "mzML$|CDF$|cdf$|mzXML$",
  fileName = character()
)

mtbls_cached_data_files(
  mtblsId = character(),
  assayName = character(),
  pattern = "*",
  fileName = character()
)

mtbls_delete_cache(mtblsId = character())
}
\arguments{
\item{x}{\code{character(1)} with the ID of the MetaboLights data set (usually
starting with a \emph{MTBLS} followed by a number).}

\item{mustWork}{for \code{mtbls_ftp_path()}: \code{logical(1)} whether the validity of
the path should be verified or not. By default (with \code{mustWork = TRUE})
the function throws an error if either the data set does not exist or
if the folder can not be accessed (e.g. if no internet connection is
available).}

\item{pattern}{for \code{mtbls_list_files()}, \code{mtbls_sync_data_files()} and
\code{mtbls_cached_data_files()}: \code{character(1)} defining a pattern
to filter the file names, such as \code{pattern = "^a_"} to retrieve the
file names of all assay files of the data set (i.e., files with a name
starting with \code{"a_"}). This parameter is passed to the \code{\link[=grepl]{grepl()}}
function.}

\item{mtblsId}{\code{character(1)} with the ID of a single MetaboLights data
set/experiment.}

\item{assayName}{\code{character} with the file names of assay files of the data
set. If not provided (\code{assayName = character()}, the default), MS data
files of all data set's assays are loaded. Use
\verb{mtbls_list_files(<MetaboLights ID>, pattern = "^a_")} to list all
available assay files of a data set \verb{<MetaboLights ID>}.}

\item{fileName}{for \code{mtbls_sync_data_files()} and
\code{mtbls_cached_data_files()}: optional \code{character}
defining the names of specific data files of a data set that should be
downloaded and cached.}
}
\value{
\itemize{
\item For \code{mtbls_ftp_path()}: \code{character(1)} with the ftp path to the specified
data set on the MetaboLights ftp server.
\item For \code{mtbls_list_files()}: \code{character} with the names of the files in the
data set's base ftp directory.
\item For \code{mtbls_sync_data_files()} and \code{mtbls_cached_data_files()}: a
\code{data.frame} with the MetaboLights ID, the assay name(s) and remote and
local file names of the synchronized data files.
}
}
\description{
\href{https://www.ebi.ac.uk/metabolights/}{MetaboLights} is one of the main
public repositories for deposition of metabolomics experiments including
(raw) mass spectrometry (MS) and NMR data files and experimental/analysis
results. The experimental metadata and results are stored as plain text
files in ISA-tab format. Each MetaboLights experiment must provide a
file describing the samples analyzed and at least one \emph{assay} file that
links between the experimental samples and the (raw and processed) data
files with quantification of metabolites/features in these samples.

Each experiment in MetaboLights is identified with its unique identifier,
starting with \emph{MTBLS} followed by a number. The data (metadata files and
MS/NMR data files) of an experiment are available through the repository's
ftp server.

The functions listed here allow to query and retrieve information of a
data set/experiment from MetaboLights.
\itemize{
\item \code{mtbls_ftp_path()}: returns the FTP path for a provided MetaboLights ID.
With \code{mustWork = TRUE} (the default) the function throws an error if
the path is not accessible (either because the data set does not exist or
no internet connection is available). The function returns a
\code{character(1)} with the FTP path to the data set folder.
\item \code{mtbls_cached_data_files()}: lists locally cached data files from
MetaboLights. Since this function evaluates only local content it does not
require an internet connection. With the default parameters all available
data files are listed. The parameters can be used to restrict the lookup.
\item \code{mtbls_list_files()}: returns the available files (and directories) for the
specified MetaboLights data set (i.e., the FTP directory content of the
data set). The function returns a \code{character} vector with the relative
file names to the absolute FTP path (\code{mtbls_ftp_path()}) of the data set.
Parameter \code{pattern} allows to filter the file names and define which
file names should be returned.
\item \code{mtbls_sync_data_files()}: synchronize data files of a specifies
MetaboLights data set eventually downloading and locally caching them.
Parameter \code{fileName} allows to specify names of selected data files to
sync.
\item \code{mtbls_delete_cache()}: removes all local content for the MetaboLights
data set with ID \code{mtblsId}. This will delete eventually present
locally cached data files for the specified data set. This does not
change any other data eventually present in the local \code{BiocFileCache}.
}
}
\examples{

## Get the FTP path to the data set MTBLS2
mtbls_ftp_path("MTBLS2")

## Retrieve available files (and directories) for the data set MTBLS2
mtbls_list_files("MTBLS2")

## Retrieve the available assay files (file names starting with "a_").
afiles <- mtbls_list_files("MTBLS2", pattern = "^a_")
afiles

## Read the content of one file
a <- read.table(paste0(mtbls_ftp_path("MTBLS2"), afiles[1L]),
    header = TRUE, sep = "\t", check.names = FALSE)
head(a)

## List all available files
mtbls_cached_data_files()
}
\author{
Johannes Rainer, Philippine Louail
}
