% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-io.R
\name{read_qza}
\alias{read_qza}
\title{read the qza file, output of qiime2.}
\usage{
read_qza(qzafile, parallel = FALSE)
}
\arguments{
\item{qzafile}{character, the format of file should be one of
`BIOMV210DirFmt`, `TSVTaxonomyDirectoryFormat`, `NewickDirectoryFormat`
and `DNASequencesDirectoryFormat`.}

\item{parallel}{logical, whether parsing the taxonomy by multi-parallel,
efault is FALSE.}
}
\value{
list contained one or multiple object of feature table,
taxonomy table, tree and represent sequences.
}
\description{
the function was designed to read the ouput of qiime2.
}
\examples{
\dontrun{
otuqzafile <- system.file("extdata", "table.qza",
                          package="MicrobiotaProcess")
otuqza <- read_qza(otuqzafile)
str(otuqza)
}
}
