% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_abundance.R
\name{mp_cal_abundance}
\alias{mp_cal_abundance}
\alias{mp_cal_abundance,MPSE-method}
\alias{mp_cal_abundance,MPSE}
\alias{mp_cal_abundance,tbl_mpse-method}
\alias{mp_cal_abundance,tbl_mpse}
\alias{mp_cal_abundance,grouped_df_mpse-method}
\alias{mp_cal_abundance,grouped_df_mpse}
\title{Calculate the (relative) abundance of each taxonomy class for each sample or group.}
\usage{
mp_cal_abundance(
  .data,
  .abundance = NULL,
  .group = NULL,
  relative = TRUE,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_abundance}{MPSE}(
  .data,
  .abundance = NULL,
  .group = NULL,
  relative = TRUE,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_abundance}{tbl_mpse}(
  .data,
  .abundance = NULL,
  .group = NULL,
  relative = TRUE,
  action = "add",
  force = FALSE,
  ...
)

\S4method{mp_cal_abundance}{grouped_df_mpse}(
  .data,
  .abundance = NULL,
  .group = NULL,
  relative = TRUE,
  action = "add",
  force = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of otu abundance to be calculated}

\item{.group}{the name of group to be calculated.}

\item{relative}{logical whether calculate the relative abundance.}

\item{action}{character, "add" joins the new information to the taxatree and 
otutree if they exists (default). In addition, All taxonomy class will be added 
the taxatree, and OTU (tip) information will be added to the otutree."only" return 
a non-redundant tibble with the just new information. "get" return 'taxatree' slot
which is a treedata object.}

\item{force}{logical whether calculate the relative abundance forcibly when the abundance 
is not be rarefied, default is FALSE.}

\item{...}{additional parameters.}
}
\value{
update object or tibble according the 'action'
}
\description{
Calculate the (relative) abundance of each taxonomy class for each sample or group.
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%<>\%
  mp_rrarefy() 
mouse.time.mpse
mouse.time.mpse \%<>\%
  mp_cal_abundance(.abundance=RareAbundance, action="add") \%>\% 
  mp_cal_abundance(.abundance=RareAbundance, .group=time, action="add") 
mouse.time.mpse
library(ggplot2)
f <- mouse.time.mpse \%>\%
     mp_plot_abundance(
        .abundance=RelRareAbundanceBySample,
        .group = time,
        taxa.class = "Phylum",
        topn = 20,
        geom = "heatmap",
        feature.dist = "bray",
        feature.hclust = "average"
     ) \%>\%
     set_scale_theme(
        x = scale_fill_manual(values=c("orange", "deepskyblue")),
        aes_var = time
     )
f
p1 <- mouse.time.mpse \%>\% 
      mp_plot_abundance(.abundance=RelRareAbundanceBySample, 
                        .group=time, taxa.class="Phylum", 
                        topn=20, order.by.feature = "p__Firmicutes",
                        width = 4/5
                        )
p2 <- mouse.time.mpse \%>\% 
      mp_plot_abundance(.abundance = RareAbundance, 
                        .group = time, 
                        taxa.class = Phylum, 
                        topn = 20, 
                        relative = FALSE, 
                        force = TRUE,
                        order.by.feature = TRUE
                        )
p1 / p2
# Or you can also extract the result and visulize it with ggplot2 and ggplot2-extension
\dontrun{
tbl <- mouse.time.mpse \%>\%
       mp_extract_abundance(taxa.class="Class", topn=10)
tbl
library(ggplot2)
library(ggalluvial)
library(dplyr)
tbl \%<>\%
  tidyr::unnest(cols=RareAbundanceBySample) 
tbl
p <- ggplot(data=tbl,
            mapping=aes(x=Sample, 
                        y=RelRareAbundanceBySample, 
                        alluvium=label,
                        fill=label)
     ) + 
     geom_flow(stat="alluvium", lode.guidance = "frontback", color = "darkgray") +
     geom_stratum(stat="alluvium") +
     labs(x=NULL, y="Relative Abundance (\%)") +
     scale_fill_brewer(name="Class", type = "qual", palette = "Paired") +
     facet_grid(cols=vars(time), scales="free_x", space="free") +
     theme(axis.text.x=element_text(angle=-45, hjust=0))
p
}
}
\seealso{
[mp_plot_abundance()] and [mp_extract_abundance()]
}
\author{
Shuangbin Xu
}
