% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_venn.R
\name{get_vennlist}
\alias{get_vennlist}
\alias{get_vennlist,phyloseq-method}
\alias{get_vennlist,phyloseq}
\alias{get_vennlist,data.frame-method}
\alias{get_vennlist,data.framet}
\title{generate a vennlist for VennDiagram}
\usage{
get_vennlist(obj, ...)

\S4method{get_vennlist}{phyloseq}(obj, factorNames, ...)

\S4method{get_vennlist}{data.frame}(obj, sampleinfo = NULL, factorNames = NULL, ...)
}
\arguments{
\item{obj}{phyloseq, phyloseq class or data.frame
a dataframe contained one character column and the others are numeric.
or all columns should be numeric if sampleinfo isn't NULL.}

\item{..., }{additional parameters}

\item{factorNames}{character, a column name of sampleinfo, 
when sampleinfo isn't NULL, factorNames shouldn't be NULL, default is NULL,
when the input is phyloseq, the factorNames should be provided.}

\item{sampleinfo}{dataframe; a sample information, default is NULL.}
}
\value{
return a list for VennDiagram.
}
\description{
generate a vennlist for VennDiagram
}
\examples{
\dontrun{
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
vennlist <- get_vennlist(test_otu_data, 
                 factorNames="group")
vennlist
library(VennDiagram)
venn.diagram(vennlist, height=5, 
             width=5, filename = "./test_venn.pdf", 
             alpha = 0.85, fontfamily = "serif", 
             fontface = "bold",cex = 1.2, 
             cat.cex = 1.2, cat.default.pos = "outer",
             cat.dist = c(0.22,0.22,0.12,0.12), 
             margin = 0.1, lwd = 3, 
             lty ='dotted', 
             imagetype = "pdf")
}
}
\author{
Shuangbin Xu
}
