% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-get-count-ratio.R
\name{get_count}
\alias{get_count}
\alias{get_ratio}
\title{calculate the count or relative abundance of replicate element with a speficify column}
\usage{
get_count(data, featurelist, ...)

get_ratio(data, featurelist, ...)
}
\arguments{
\item{data}{dataframe; a dataframe contained one character column and others is numeric,
if featurelist is NULL. Or a numeirc dataframe, if featurelist is non't NULL, all columns 
should be numeric.}

\item{featurelist}{dataframe; a dataframe contained one chatacter column, default is NULL.}

\item{...}{additional parameters.}
}
\value{
mean of data.frame by featurelist
}
\description{
Caculate the count or relative abundance of replicate element with a speficify columns
}
\examples{
\dontrun{
otudafile <- system.file("extdata", "otu_tax_table.txt", 
                      package="MicrobiotaProcess")
samplefile <- system.file("extdata", 
                 "sample_info.txt", package="MicrobiotaProcess")
otuda <- read.table(otudafile, sep="\t", header=TRUE, 
                    row.names=1, check.names=FALSE, 
                    skip=1, comment.char="")
sampleda <- read.table(samplefile, 
            sep="\t", header=TRUE, row.names=1)
taxdf <- otuda[!sapply(otuda, is.numeric)]
taxdf <- split_str_to_list(taxdf)
otuda <- otuda[sapply(otuda, is.numeric)]
phycount <- get_count(otuda, taxdf[,2,drop=FALSE])
phyratios <- get_ratio(otuda, taxdf[,2,drop=FALSE])
}
}
\author{
Shuangbin Xu
}
