% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-diff-analysis.R
\name{get_alltaxadf}
\alias{get_alltaxadf}
\alias{get_alltaxadf,phyloseq-method}
\alias{get_alltaxadf,phyloseq}
\alias{get_alltaxadf,data.frame-method}
\alias{get_alltaxadf,data.frame}
\title{get the table of abundance of all level taxonomy}
\usage{
get_alltaxadf(obj, ...)

\S4method{get_alltaxadf}{phyloseq}(
  obj,
  method = NULL,
  type = "species",
  include.rownames = FALSE,
  ...
)

\S4method{get_alltaxadf}{data.frame}(
  obj,
  taxda,
  taxa_are_rows = FALSE,
  method = NULL,
  type = "species",
  include.rownames = FALSE,
  ...
)
}
\arguments{
\item{obj}{object, phyloseq or data.frame}

\item{..., }{additional parameters, see also \code{\link[vegan]{decostand}}.}

\item{method}{character, the normalization method, 
see also \code{\link[vegan]{decostand}}, default is NULL, the relative abundance 
will be return, if it set `count`, the count table will be return.}

\item{include.rownames}{logical whether to calculate the original feature data, 
default is FALSE.}

\item{taxda}{data.frame, the taxonomy table.}

\item{taxa_are_rows}{logical, if the obj is data.frame, and the features are rownames,
the taxa_are_rows should be set TRUE, default FALSE, meaning the features are colnames.}
}
\value{
the all taxonomy abundance table
}
\description{
This function was designed to get the abundance of all level taxonomy,
the input can be phyloseq object or data.frame.
}
\examples{
\dontrun{
   data(test_otu_data)
   alltaxatab <- get_alltaxadf(test_otu_data)
   head(alltaxatab[,1:10])
}
}
\author{
Shuangbin Xu
}
\keyword{internal}
