% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pd_metric.R
\name{get_NRI_NTI}
\alias{get_NRI_NTI}
\alias{get_NRI_NTI,matrix-method}
\alias{get_NRI_NTI,matrix}
\alias{get_NRI_NTI,data.frame-method}
\alias{get_NRI_NTI,data.frame}
\alias{get_NRI_NTI,phyloseq-method}
\alias{get_NRI_NTI,phyloseq}
\title{calculating related phylogenetic alpha metric}
\usage{
get_NRI_NTI(obj, ...)

\S4method{get_NRI_NTI}{matrix}(
  obj,
  mindepth,
  sampleda,
  tree,
  metric = c("PAE", "NRI", "NTI", "PD", "HAED", "EAED", "IAC", "all"),
  abundance.weighted = FALSE,
  force = FALSE,
  seed = 123,
  ...
)

\S4method{get_NRI_NTI}{data.frame}(obj, mindepth, sampleda, tree, abundance.weighted = TRUE, ...)

\S4method{get_NRI_NTI}{phyloseq}(obj, mindepth, abundance.weighted = TRUE, ...)
}
\arguments{
\item{obj}{object, data.frame of (nrow sample * ncol taxonomy(feature)) 
or phyloseq.}

\item{...}{additional arguments, meaningless now.}

\item{mindepth}{numeric, Subsample size for rarefying community.}

\item{sampleda}{data.frame, sample information, row sample * column factors.}

\item{tree}{tree object, it can be phylo object or treedata object.}

\item{metric}{the related phylogenetic metric, options is 'NRI', 'NTI', 'PD', 'PAE', 'HAED', 'EAED', 'IAC', 'all',
default is 'PAE', meaning all the metrics ('NRI', 'NTI', 'PD', 'PAE', 'HAED', 'EAED', 'IAC').}

\item{abundance.weighted}{logical, whether calculate mean nearest taxon distances for each species 
weighted by species abundance, default is FALSE.}

\item{force}{logical whether calculate the index even the count of otu is
not rarefied, default is FALSE. If it is TRUE, meaning the rarefaction is not be
performed automatically.}

\item{seed}{integer a random seed to make the result reproducible, default is 123.}
}
\value{
alphasample object contained NRT and NTI.
}
\description{
calculating related phylogenetic alpha metric
}
\author{
Shuangbin Xu
}
