% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ORA_annotations.R
\name{get_ORA_annotations}
\alias{get_ORA_annotations}
\title{Retrieve background and annotation information for over-representation analysis
(ORA)}
\usage{
get_ORA_annotations(
  data,
  kegg = "KEGG",
  metabolite_name = "metabolite",
  update_background = TRUE
)
}
\arguments{
\item{data}{data frame to be analyzed with ORA. Must at least contain a column
with KEGG IDs or a \link[SummarizedExperiment]{SummarizedExperiment}  where the metabolite
names or IDs are stored in colData}

\item{kegg}{column name of "data" that holds KEGG IDs}

\item{metabolite_name}{column name of "data" that holds metabolite names}

\item{update_background}{logical. Should the background information be updated?
Should be set to TRUE of this is the first time using this function.
If TRUE this may take some time.}
}
\value{
a list with dataframes "background" and "annotation" needed for ORA,
if data is a SummarizedExperiment \link[SummarizedExperiment]{SummarizedExperiment}  object annotations are stored in metadata(data)
under "KEGG_annotations"
}
\description{
Uses the package KEGGREST to retrieve background and annotation information
needed for over-representation analysis. As KEGGREST only allows 10 queries
per second this might take some time to run, depending on the size of the
dataset and organism. The user should check afterwards if all functional modules are
applicable for the analysis of the dataset (p.e. organism, tissue).
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition == "A" &
  longitudinalMetabolomics$metabolite == "ATP"]
data <- get_ORA_annotations(
  data = data,
  kegg = "KEGG",
  metabolite_name = "metabolite",
  update_background = FALSE
)
S4Vectors::metadata(data)[["KEGG_annotations"]]
}
\seealso{
Do over-representation analysis of KEGG functional modules \code{\link[=ORA_hypergeometric]{ORA_hypergeometric()}}
}
