% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_metabolites.R
\name{compare_metabolites}
\alias{compare_metabolites}
\title{Comparison of metabolite sets between dynamics clusters of different experimental conditions}
\usage{
compare_metabolites(data)
}
\arguments{
\item{data}{result of \code{\link[=cluster_dynamics]{cluster_dynamics()}} function: either a list of data frames or a SummarizedExperiment object}
}
\value{
a data frame of Jaccard indices between data or if data input
was a SummarizedExperiment results are stored in metadata(data) under
"comparison_metabolites"
}
\description{
Uses the Jaccard Index to compare metabolite names between dynamics clusters of
different experimental conditions
}
\examples{
data("longitudinalMetabolomics")
longitudinalMetabolomics <- compare_metabolites(
  data = longitudinalMetabolomics
)
S4Vectors::metadata(longitudinalMetabolomics)[["comparison_metabolites"]]
}
\seealso{
Visualization of metabolite similarity \code{\link[=heatmap_metabolites]{heatmap_metabolites()}}/
compare dynamics of clusters \code{\link[=compare_dynamics]{compare_dynamics()}}
}
