% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/021.bkc_bkb.R
\name{bkc_bkb}
\alias{bkc_bkb}
\title{Background correction for the backbone markers}
\usage{
bkc_bkb(
  paths,
  bkb.v,
  MPC,
  bkb.upper.quantile = 0.9,
  bkb.lower.quantile = 0.1,
  bkb.min.quantile = 0.01,
  plots = TRUE
)
}
\arguments{
\item{paths}{a vector of characters of paths to store intput, intermediary results, outputs...}

\item{bkb.v}{a vector of the names of the backbone markers (MUST match to the names in the FCS file).}

\item{MPC}{if the data is from MPC experiments, set \code{MPC = TRUE}. Setting FALSE represents data from the fluorescence flow cytometry (FFC) assay.}

\item{bkb.upper.quantile}{the cut-off (default = 0.9) for selecting cells used for estimating the parameter of signal.}

\item{bkb.lower.quantile}{the cut-off (default = 0.1) for selecting cells used for estimating the parameters of noise.}

\item{bkb.min.quantile}{the cut-off (default = 0.01) for omitting the cells with the smallest values to minimise the impact of outliers.}

\item{plots}{logical; if TRUE (default), produce scatter plots for pre- and post- background adjusted backbone markers (calibrated values on y-axis and raw values on x-axis).}
}
\value{
Background noise corrected backbone markers and graphs if specified
}
\description{
This function has been designed to do background correction for the backbone markers by using normal-exponential convolution model.
}
\details{
Generating the calibrated measurements and save to medpara_bkc.bkb_no.bkcPhy_mt.rds file, and visualising the result with the scatter plots in the output directory.
}
\author{
Hsiao-Chi Liao and Agus Salim
}
