% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqueSeqs.R
\name{uniqueSeqs}
\alias{uniqueSeqs}
\title{Unique sequences}
\usage{
uniqueSeqs(productive.aa)
}
\arguments{
\item{productive.aa}{A list data frames of of productive amino acid sequences 
imported using the function LymphoSeq function productiveSeq where the 
aggregate parameter was set to "aminoAcid".}
}
\value{
A data frame of unique amino acid sequences from the list of 
data frames aggregated by count.
}
\description{
Aggregates all productive sequences within a list of data frames by count.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

unique.seqs <- uniqueSeqs(productive.aa = productive.aa)
}
