% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePlot.R
\name{pairwisePlot}
\alias{pairwisePlot}
\title{Pairwise comparison plot}
\usage{
pairwisePlot(matrix)
}
\arguments{
\item{matrix}{A similarity or Bhattacharyya matrix produced by the LymphoSeq 
functions similarityMatrix or bhattacharyyaMatrix.}
}
\value{
A pairwise comparison heat map.
}
\description{
Creates a heat map from a similarity or Bhattacharyya matrix.
}
\details{
The plot is made using the package ggplot2 and can be reformatted
using ggplot2 functions.  See examples below.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

similarity.matrix <- similarityMatrix(productive.seqs = productive.aa)

pairwisePlot(matrix = similarity.matrix)

bhattacharyya.matrix <- bhattacharyyaMatrix(productive.seqs = productive.aa)

pairwisePlot(matrix = bhattacharyya.matrix)

# Change plot color, title legend, and add title
pairwisePlot(matrix = similarity.matrix) + 
   ggplot2::scale_fill_gradient(low = "#deebf7", high = "#3182bd") + 
   ggplot2::labs(fill = "Similarity score") + ggplot2::ggtitle("Figure Title")
}
\seealso{
An excellent resource for examples on how to reformat a ggplot can 
be found in the R Graphics Cookbook online (\url{http://www.cookbook-r.com/Graphs/}).
The functions to create the similarity or Bhattacharyya matrix can be found 
here: \code{\link{similarityMatrix}} and \code{\link{bhattacharyyaMatrix}}
}
