% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialAbundance.R
\name{differentialAbundance}
\alias{differentialAbundance}
\title{Differential abundance analysis}
\usage{
differentialAbundance(sample1, sample2, list,
  abundance = "estimatedNumberGenomes", type = "aminoAcid", q = 1,
  zero = 0.001, parallel = FALSE)
}
\arguments{
\item{sample1}{A character vector indicating the name of the first sample in the list
to be compared.}

\item{sample2}{A character vector indicating the name of the second sample in the list
to be compared.}

\item{list}{A list of data frames consisting of antigen receptor sequences 
imported by the LymphoSeq function readImmunoSeq.}

\item{abundance}{The input value for the Fisher exact test.  "estimatedNumberGenomes"
is recommend but "count" may also be used.}

\item{type}{A character vector indicating whether "aminoAcid" or "nucleotide" sequences
should be used.  If "aminoAcid" is specified, then run productiveSeqs first.}

\item{q}{A numeric value between 0.0 and 1.0 indicating the threshold Holms adjusted 
P value (also knowns as the false discovery rate or q value) to subset the results with.  
Any sequences with a q value greater than this value will not be shown.}

\item{zero}{A numeric value to set all zero values to when calculating the log2
transformed fold change between samples 1 and 2.  This does not apply to the 
p and q value calculations.}

\item{parallel}{A boolean indicating wheter parallel processing should be used or not.}
}
\value{
Returns a data frame with columns corresponding to the frequency of the abudance
measure in samples 1 and 2, the P value, Q value (Holms adjusted P value, also knowns as 
the false discovery rate), and log2 transformed fold change.
}
\description{
Use a Fisher exact test to calculate differential abdunance of each sequence in 
two samples and reports the log2 transformed fold change, P value and adjusted P value.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

differentialAbundance(list = productive.aa, sample1 = "TRB_Unsorted_949", 
                      sample2 = "TRB_Unsorted_1320", type = "aminoAcid", q = 0.01, 
                      zero = 0.001)
}
