% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLocEnrichment.R
\name{runLOLA}
\alias{runLOLA}
\title{Enrichment Calculation}
\usage{
runLOLA(
  userSets,
  userUniverse,
  regionDB,
  minOverlap = 1,
  cores = 1,
  redefineUserSets = FALSE,
  direction = "enrichment"
)
}
\arguments{
\item{userSets}{Regions of interest}

\item{userUniverse}{Regions tested for inclusion in userSets}

\item{regionDB}{Region DB to check for overlap, from loadRegionDB()}

\item{minOverlap}{(Default:1) Minimum bases required to count an overlap}

\item{cores}{Number of processors}

\item{redefineUserSets}{run redefineUserSets() on your userSets?}

\item{direction}{Defaults to "enrichment", but may also accept
"depletion", which will swap the direction of the fisher test (use
'greater' or less' value passed to the 'alternative' option of
fisher.test)}
}
\value{
Data.table with enrichment results. Rows correspond to individual
pairwise fisher's tests comparing a single userSet with a single databaseSet.
The columns in this data.table are: userSet and dbSet: index into their
respective input region sets. pvalueLog: -log10(pvalue) from the fisher's exact
result; oddsRatio: result from the fisher's exact test; support: number of
regions in userSet overlapping databaseSet; rnkPV, rnkOR, rnkSup: rank in this
table of p-value, oddsRatio, and Support respectively. The --value is the
negative natural log of the p-value returned from a one-sided fisher's exact
test. maxRnk, meanRnk: max and mean of the 3 previous ranks, providing a
combined ranking system. b, c, d: 3 other values completing the 2x2 contingency
table (with support). The remaining columns describe the dbSet for the row.

If you have the qvalue package installed from bioconductor, runLOLA will add
a q-value transformation to provide FDR scores automatically.
}
\description{
Workhorse function that calculates overlaps between userSets,
and then uses a fisher's exact test rank them by significance
of the overlap.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionDB = loadRegionDB(dbLocation=dbPath)
data("sample_universe", package="LOLA")
data("sample_input", package="LOLA")

getRegionSet(regionDB, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionSet(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")
getRegionFile(dbPath, collections="ucsc_example", filenames="vistaEnhancers.bed")


res = runLOLA(userSets, userUniverse, regionDB, cores=1)
locResult = res[2,]
extractEnrichmentOverlaps(locResult, userSets, regionDB)
writeCombinedEnrichment(locResult, "temp_outfolder")

userSetsRedefined =	redefineUserSets(userSets, userUniverse)
resRedefined = runLOLA(userSetsRedefined, userUniverse, regionDB, cores=1)

g = plotTopLOLAEnrichments(resRedefined)

}
