% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25.setup_GSEA.R
\name{setup_GSEA}
\alias{setup_GSEA}
\title{prepare files for GSEA analysis}
\usage{
setup_GSEA(
  eset,
  groupList,
  outdir = getInPASOutputDirectory(),
  preranked = TRUE,
  rankBy = c("logFC", "P.value"),
  rnkFilename = "InPAS.rnk",
  chipFilename = "InPAS.chip",
  dataFilename = "dPDUI.txt",
  PhenFilename = "group.cls"
)
}
\arguments{
\item{eset}{A \linkS4class{UTR3eSet} object, output of \code{\link[=test_dPDUI]{test_dPDUI()}}}

\item{groupList}{A list of grouped sample tag names, with the group names as
the list's name, such as list(groupA = c("sample_1", "sample_2",
"sample_3"), groupB = c("sample_4", "sample_5", "sample_6"))}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}

\item{preranked}{A logical(1) vector, out preranked or not}

\item{rankBy}{A character(1) vector, indicating how the gene list is ranked.
It can be "logFC" or "P.value".}

\item{rnkFilename}{A character(1) vector, specifying a filename for the
preranked file}

\item{chipFilename}{A character(1) vector, specifying a filename for the
chip file}

\item{dataFilename}{A character(1) vector, specifying a filename for the
dataset file}

\item{PhenFilename}{A character(1) vector, specifying a filename for the
file containing samples' phenotype labels}
}
\description{
output the log2 transformed delta PDUI txt file, chip file, rank file and
phynotype label file for GSEA analysis
}
\examples{
library(limma)
path <- system.file("extdata", package = "InPAS")
load(file.path(path, "eset.MAQC.rda"))
tags <- colnames(eset@PDUI)
g <- factor(gsub("\\\\..*$", "", tags))
design <- model.matrix(~ -1 + g)
colnames(design) <- c("Brain", "UHR")
contrast.matrix <- makeContrasts(
  contrasts = "Brain-UHR",
  levels = design
)
res <- test_dPDUI(
  eset = eset,
  method = "limma",
  normalize = "none",
  design = design,
  contrast.matrix = contrast.matrix
)
gp1 <- c("Brain.auto", "Brain.phiX")
gp2 <- c("UHR.auto", "UHR.phiX")
groupList <- list(Brain = gp1, UHR = gp2)
setup_GSEA(res,
  groupList = groupList,
  outdir = tempdir(),
  preranked = TRUE,
  rankBy = "P.value"
)
}
\seealso{
data formats for GSEA.
\url{https://software.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}
}
\author{
Jianhong Ou, Haibo Liu
}
