% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/18.get_UTR3CDS.R
\name{get_UTR3CDS}
\alias{get_UTR3CDS}
\title{Get 3' UTRs and their last CDS regions based on CP sites}
\usage{
get_UTR3CDS(
  sqlite_db,
  chr.utr3,
  outdir = getInPASOutputDirectory(),
  min.length.diff = 200
)
}
\arguments{
\item{sqlite_db}{A path to the SQLite database for InPAS, i.e. the output of
setup_sqlitedb().}

\item{chr.utr3}{An object of \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}, specifying UTR3
GRanges for a chromosome. It must be one element of an output of
\code{\link[=extract_UTR3Anno]{extract_UTR3Anno()}}.}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}

\item{min.length.diff}{An integer(1) vector, specifying minimal length
difference between proximal and distal APA sites which should be met to be
considered for differential APA analysis. Default is 200 bp.}
}
\value{
An object of \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges} containing GRanges for
UTRs with alternative CP sites and the corresponding last CDSs.
}
\description{
Get 3' UTRs and their last CDS regions based on CP sites
}
\author{
Jianhong Ou, Haibo Liu
}
\keyword{internal}
