% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{cumulative_is}
\alias{cumulative_is}
\title{Expands integration matrix with the cumulative IS union over time.}
\usage{
cumulative_is(
  x,
  key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  timepoint_col = "TimePoint",
  include_tp_zero = FALSE,
  counts = TRUE,
  keep_og_is = FALSE,
  expand = TRUE
)
}
\arguments{
\item{x}{An integration matrix, ideally aggregated via
\code{aggregate_values_by_key()}}

\item{key}{The aggregation key used}

\item{timepoint_col}{The name of the time point column}

\item{include_tp_zero}{Should time point 0 be included?}

\item{counts}{Add cumulative counts? Logical}

\item{keep_og_is}{Keep original set of integrations as a separate column?}

\item{expand}{If \code{FALSE}, for each group, the set of integration sites is
returned in a separate column as a nested table, otherwise the resulting
column is unnested.}
}
\value{
A data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Given an input integration matrix that can be grouped over time,
this function adds integrations in groups assuming that
if an integration is observed at time point "t" then it is also observed in
time point "t+1".
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item All columns declared in \code{mandatory_IS_vars()}
\item Checks if the matrix is annotated by assessing presence of
\code{annotation_IS_vars()}
}
}

\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
cumulated_is <- cumulative_is(aggreg)
cumulated_is
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{compute_abundance}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{is_sharing}()},
\code{\link{iss_source}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
