% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{select}
\alias{select}
\alias{select.GDCQuery}
\title{S3 generic to set GDCQuery fields}
\usage{
select(x, fields)

\method{select}{GDCQuery}(x, fields)
}
\arguments{
\item{x}{the objects on which to set fields}

\item{fields}{a character vector specifying the fields}
}
\value{
A \code{\link{GDCQuery}} object, with the fields
member altered.
}
\description{
S3 generic to set GDCQuery fields
}
\section{Methods (by class)}{
\itemize{
\item \code{select(GDCQuery)}: set fields on a GDCQuery object

}}
\examples{
gProj = projects()
gProj$fields
head(available_fields(gProj))
default_fields(gProj)

gProj |>
  select(default_fields(gProj)[1:2]) |>
  response() |>
  str(max_level=2)

}
