% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHTSeqFile.R
\name{readHTSeqFile}
\alias{readHTSeqFile}
\title{Read a single htseq-counts result file.}
\usage{
readHTSeqFile(fname, samplename = "sample", ...)
}
\arguments{
\item{fname}{character(1), the path of the htseq-count file.}

\item{samplename}{character(1), the name of the sample. This will
become the name of the second column on the resulting
\code{data.frame}, making for easier merging if necessary.}

\item{...}{passed to \code{\link[readr]{read_tsv})}}
}
\value{
a two-column data frame
}
\description{
The htseq package is used extensively to count reads
relative to regions (see 
\url{http://www-huber.embl.de/HTSeq/doc/counting.html}).
The output of htseq-count is a simple two-column table
that includes features in column 1 and counts in column 2.
This function simply reads in the data from one such file
and assigns column names.
}
\examples{
fname = system.file(package='GenomicDataCommons',
                    'extdata/example.htseq.counts.gz')
dat = readHTSeqFile(fname)
head(dat)

}
