% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{plotGBSR}
\alias{plotGBSR}
\title{Draw line plots of specified statistics}
\usage{
plotGBSR(
  x,
  stats = c("dp", "missing", "het"),
  coord = NULL,
  lwd = 0.5,
  binwidth = NULL,
  color = c(Marker = "darkblue", Ref = "darkgreen", Het = "magenta", Alt = "blue")
)
}
\arguments{
\item{x}{A \link{GbsrGenotypeData} object.}

\item{stats}{A string to specify statistics to be drawn.}

\item{coord}{A vector with two integer specifying the number of rows
and columns to draw faceted line plots for chromosomes.}

\item{lwd}{A numeric value to specify the line width in plots.}

\item{binwidth}{An integer to specify bin width of the histogram.
This argument only work with \code{stats = "marker"} and is passed to the ggplot
function.}

\item{color}{A strings vector named "Marker", "Ref", "Het", "Alt"
to specify line colors. \verb{stats = "geno} only requires "Ref", "Het" and "Alt",
while others uses the value named "Marker".}
}
\value{
A ggplot object.
}
\description{
Draw line plots of specified statistics
}
\details{
You can draw line plots of several summary statistics of genotype counts
and read counts per sample and per marker. The "stats" argument can take
the following values:
\describe{
\item{marker}{Marker density.}
\item{geno}{Proportion of missing genotype calls.}
\item{missing}{Proportion of missing genotype calls.}
\item{het}{Proportion of heterozygote calls.}
\item{raf}{Reference allele frequency.}
\item{dp}{Total read counts.}
\item{ad_ref}{Reference allele read counts.}
\item{ad_alt}{Alternative allele read counts.}
\item{rrf}{Reference allele read frequency.}
\item{mean_ref}{Mean of reference allele read counts.}
\item{sd_ref}{Standard deviation of reference allele read counts.}
\item{median_ref}{Quantile of reference allele read counts.}
\item{mean_alt}{Mean of alternative allele read counts.}
\item{sd_alt}{Standard deviation of alternative allele read counts.}
\item{median_alt}{Quantile of alternative allele read counts.}
\item{mq}{Mapping quality.}
\item{fs}{Phred-scaled p-value (strand bias)}
\item{qd}{Variant Quality by Depth}
\item{sor}{Symmetric Odds Ratio (strand bias)}
\item{mqranksum}{Alt vs. Ref read mapping qualities}
\item{readposranksum}{Alt vs. Ref read position bias}
\item{baseqranksum}{Alt Vs. Ref base qualities}
}

To draw line plots for "missing", "het", "raf", you need to run
\code{\link[=countGenotype]{countGenotype()}} first to obtain statistics. Similary, "dp",
"ad_ref", "ad_alt", "rrf" requires values obtained via \code{\link[=countRead]{countRead()}}.
"mq", "fs", "qd", "sor", "mqranksum", "readposranksum",
#' and "baseqranksum" only work with \code{target = "marker"}, if your data
contains those values supplied via SNP calling tools like
\href{https://gatk.broadinstitute.org/hc/en-us}{GATK}.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize genotype count information to be used in `plotGBSR()`
gds <- countGenotype(gds)

# Draw line plots of missing rate, heterozygosity, proportion of genotype
# calls per SNP.
plotGBSR(gds, stats = "missing")

# Close the connection to the GDS file
closeGDS(gds)

}
