% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getParents}
\alias{getParents}
\alias{getParents,GbsrGenotypeData-method}
\title{Get parental sample information}
\usage{
getParents(object, bool = FALSE, verbose = TRUE, ...)

\S4method{getParents}{GbsrGenotypeData}(object, bool, verbose = TRUE)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{bool}{If TRUE, the function returns a logical vector indicating
which samples have been set as parents.}

\item{verbose}{If FALSE, the function does not print a warning message even
when parents were not specified in the given \link{GbsrGenotypeData} object. The
setting \code{verbose = FALSE} is used in the other functions to call
\code{getParents()} without evoking unnecessary warnings to users.}

\item{...}{Unused.}
}
\value{
A data frame of parents information indicating sampleIDs, memberIDs
and indexes of parental lines assigned via \code{\link[=setParents]{setParents()}}.
}
\description{
This function returns sample IDs, member IDs and indexes of parental samples
set via \code{\link[=setParents]{setParents()}}. Sample IDs are IDs given by user or obtained from the
original VCF file. Member IDs are serial numbers assigned by \code{\link[=setParents]{setParents()}}.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Find the IDs of parental samples.
parents <- grep("Founder", getSamID(gds), value = TRUE)

# Set the parents.
gds <- setParents(gds, parents = parents)

# Get the information of parents.
getParents(gds)

# Close the connection to the GDS file.
closeGDS(gds)


}
