% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getMAF}
\alias{getMAF}
\alias{getMAF,GbsrGenotypeData-method}
\title{Obtain minor allele frequencies per SNP or per sample}
\usage{
getMAF(object, target = "marker", valid = TRUE, ...)

\S4method{getMAF}{GbsrGenotypeData}(object, target, valid)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{valid}{A logical value. See details.}

\item{...}{Unused.}
}
\value{
A numeric vector of the minor allele frequencies per marker.
}
\description{
Obtain minor allele frequencies per SNP or per sample
}
\details{
You need to execute \code{\link[=countGenotype]{countGenotype()}} to calculate sumaary statisticsto be
obtained via this function.
If \code{valid = TRUE}, the chromosome information of markers which are
labeled \code{TRUE} in the \link{sample} slot will be returned.
\code{\link[=validMar]{validMar()}} tells you which samples are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize the genotype count information and store them in the
# [marker] and [sample] slots of the [GbsrGenotypeData] object.
gds <- countGenotype(gds)

getMAF(gds)

# Close the connection to the GDS file
closeGDS(gds)

}
