% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getCountReadRef}
\alias{getCountReadRef}
\alias{getCountReadRef,GbsrGenotypeData-method}
\title{Obtain total reference read counts per SNP or per sample}
\usage{
getCountReadRef(object, target = "marker", valid = TRUE, prop = FALSE, ...)

\S4method{getCountReadRef}{GbsrGenotypeData}(object, target, valid, prop)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{valid}{A logical value. See details.}

\item{prop}{A logical value whether to return values as proportions of
total reference read counts in total read counts per SNP or not.}

\item{...}{Unused.}
}
\value{
A numeric vector of (proportion of) reference read
counts per marker.
}
\description{
Obtain total reference read counts per SNP or per sample
}
\details{
You need to execute \code{\link[=countRead]{countRead()}} to calculate sumaary statisticsto be
obtained via this function.
If \code{valid = TRUE}, the chromosome information of markers which are
labeled \code{TRUE} in the \link{sample} slot will be returned.
\code{\link[=validMar]{validMar()}} tells you which samples are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)
gds <- countRead(gds)

getCountReadRef(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
